/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.WidgetTag;
import org.apache.rave.portal.repository.WidgetTagRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultWidgetTagPermissionEvaluator
extends AbstractModelPermissionEvaluator<WidgetTag> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WidgetTagRepository widgetTagRepository;

    @Autowired
    public DefaultWidgetTagPermissionEvaluator(WidgetTagRepository widgetTagRepository) {
        this.widgetTagRepository = widgetTagRepository;
    }

    @Override
    public Class<WidgetTag> getType() {
        return WidgetTag.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, WidgetTag widgetTag, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, widgetTag, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId, permission) : this.hasPermission(authentication, (WidgetTag)this.widgetTagRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, WidgetTag widgetTag, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<WidgetTag> trustedWidgetTagContainer = new ArrayList<WidgetTag>();
        if (super.hasPermission(authentication, widgetTag, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case READ: {
                hasPermission = true;
                break;
            }
            case CREATE: {
                hasPermission = this.isWidgetTagOwnerById(authentication, widgetTag.getUser().getEntityId());
                break;
            }
            case DELETE: 
            case UPDATE: {
                hasPermission = this.isWidgetTagOwner(authentication, widgetTag, trustedWidgetTagContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext, ModelPermissionEvaluator.Permission permission) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (WidgetTag.class == clazz) {
            boolean hasPermission = false;
            switch (permission) {
                case ADMINISTER: {
                    break;
                }
                case READ: {
                    hasPermission = true;
                    break;
                }
                case CREATE: 
                case DELETE: 
                case UPDATE: {
                    hasPermission = this.isWidgetTagOwnerById(authentication, (Long)raveSecurityContext.getId());
                    break;
                }
                default: {
                    this.log.warn("unknown permission: " + (Object)((Object)permission));
                }
            }
            return hasPermission;
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private boolean isWidgetTagOwner(Authentication authentication, WidgetTag widgetTag, List<WidgetTag> trustedWidgetTagContainer, boolean trustedDomainObject) {
        WidgetTag trustedWidgetTag = null;
        trustedWidgetTag = trustedDomainObject ? widgetTag : this.getTrustedWidgetTag(widgetTag.getEntityId(), trustedWidgetTagContainer);
        return this.isWidgetTagOwnerByUsername(authentication, trustedWidgetTag.getUser().getUsername());
    }

    private WidgetTag getTrustedWidgetTag(long widgetTagId, List<WidgetTag> trustedWidgetTagContainer) {
        WidgetTag p = null;
        if (trustedWidgetTagContainer.isEmpty()) {
            p = (WidgetTag)this.widgetTagRepository.get(widgetTagId);
            trustedWidgetTagContainer.add(p);
        } else {
            p = trustedWidgetTagContainer.get(0);
        }
        return p;
    }

    private boolean isWidgetTagOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isWidgetTagOwnerById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }
}

