/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.Date;
import java.util.List;
import org.apache.rave.portal.model.Category;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.portal.service.CategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultCategoryService
implements CategoryService {
    private final CategoryRepository categoryRepository;

    @Autowired
    public DefaultCategoryService(CategoryRepository categoryRepository) {
        this.categoryRepository = categoryRepository;
    }

    @Override
    public Category get(long entityId) {
        return (Category)this.categoryRepository.get(entityId);
    }

    @Override
    public List<Category> getAll() {
        return this.categoryRepository.getAll();
    }

    @Override
    @Transactional
    public Category create(String text, User createdUser) {
        Category category = new Category();
        Date now = new Date();
        category.setText(text);
        category.setCreatedDate(now);
        category.setCreatedUser(createdUser);
        category.setLastModifiedDate(now);
        category.setLastModifiedUser(createdUser);
        this.categoryRepository.save(category);
        return category;
    }

    @Override
    @Transactional
    public Category update(long categoryId, String text, User lastModifiedUser) {
        Category category = (Category)this.categoryRepository.get(categoryId);
        category.setText(text);
        category.setLastModifiedDate(new Date());
        category.setLastModifiedUser(lastModifiedUser);
        this.categoryRepository.save(category);
        return category;
    }

    @Override
    @Transactional
    public void delete(Category category) {
        Category categoryToBeDeleted = (Category)this.categoryRepository.get(category.getEntityId());
        this.categoryRepository.delete(categoryToBeDeleted);
    }
}

