/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PreRemove;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.rave.persistence.BasicEntity;
import org.apache.rave.portal.model.Authority;
import org.apache.rave.portal.model.PageLayout;
import org.apache.rave.portal.model.Person;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@NamedQueries(value={@NamedQuery(name="User.getByUsername", query="select u from User u where u.username = :username"), @NamedQuery(name="User.getByUserEmail", query="select u from User u where u.email = :email"), @NamedQuery(name="User.getAll", query="select u from User u order by u.username asc"), @NamedQuery(name="User.getByForgotPasswordHash", query="select u from User u where u.forgotPasswordHash = :forgotPasswordHash"), @NamedQuery(name="User.countAll", query="select count(u) from User u"), @NamedQuery(name="User.findByUsernameOrEmail", query="select u from User u where lower(u.username) like :searchTerm or lower(u.email) like :searchTerm order by u.username asc"), @NamedQuery(name="User.countFindByUsernameOrEmail", query="select count(u) from User u where lower(u.username) like :searchTerm or lower(u.email) like :searchTerm"), @NamedQuery(name="User.getAllForAddedWidget", query="select distinct(rw.region.page.owner) from RegionWidget rw where rw.widget.entityId = :widgetId order by rw.region.page.owner.familyName, rw.region.page.owner.givenName")})
public class User
extends Person
implements UserDetails,
BasicEntity,
Serializable,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final String USER_GET_BY_USERNAME = "User.getByUsername";
    public static final String USER_GET_BY_USER_EMAIL = "User.getByUserEmail";
    public static final String USER_GET_ALL = "User.getAll";
    public static final String USER_COUNT_ALL = "User.countAll";
    public static final String USER_FIND_BY_USERNAME_OR_EMAIL = "User.findByUsernameOrEmail";
    public static final String USER_COUNT_FIND_BY_USERNAME_OR_EMAIL = "User.countFindByUsernameOrEmail";
    public static final String USER_GET_COMMENTERS = "User.getCommenters";
    public static final String USER_GET_ALL_FOR_ADDED_WIDGET = "User.getAllForAddedWidget";
    public static final String USER_GET_BY_FORGOT_PASSWORD_HASH = "User.getByForgotPasswordHash";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_FORGOT_PASSWORD_HASH = "forgotPasswordHash";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_SEARCHTERM = "searchTerm";
    public static final String PARAM_WIDGET_ID = "widgetId";
    @Basic
    @Column(name="password")
    private String password;
    @Basic
    @Column(name="expired")
    private boolean expired;
    @Basic
    @Column(name="locked")
    private boolean locked;
    @Basic
    @Column(name="enabled")
    private boolean enabled;
    @Basic
    @Column(name="openid")
    private String openId;
    @Basic
    @Column(name="forgotPasswordHash", unique=true)
    private String forgotPasswordHash;
    @Basic
    @Column(name="password_hash_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date forgotPasswordTime;
    @ManyToOne
    @JoinColumn(name="default_page_layout_id")
    private PageLayout defaultPageLayout;
    @Transient
    private String confirmPassword;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_authorities", joinColumns={@JoinColumn(name="user_id", referencedColumnName="entity_id")}, inverseJoinColumns={@JoinColumn(name="authority_id", referencedColumnName="entity_id")})
    private Collection<Authority> authorities;
    private static int pcInheritedFieldCount = Person.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$Person;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$PageLayout;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$User;

    public User() {
        this(null, null);
    }

    public User(Long entityId) {
        this(entityId, null);
    }

    public User(Long entityId, String username) {
        this.entityId = entityId;
        this.username = username;
        this.authorities = new ArrayList<Authority>();
    }

    @Override
    public Long getEntityId() {
        return Person.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        Person.pcSetentityId(this, entityId);
    }

    public Collection<GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        grantedAuthorities.addAll(User.pcGetauthorities(this));
        return grantedAuthorities;
    }

    public void addAuthority(Authority authority) {
        if (!User.pcGetauthorities(this).contains(authority)) {
            User.pcGetauthorities(this).add(authority);
        }
        if (!authority.getUsers().contains(this)) {
            authority.addUser(this);
        }
    }

    public void removeAuthority(Authority authority) {
        if (User.pcGetauthorities(this).contains(authority)) {
            User.pcGetauthorities(this).remove(authority);
        }
    }

    public void setAuthorities(Collection<Authority> newAuthorities) {
        User.pcSetauthorities(this, newAuthorities);
    }

    public String getPassword() {
        return User.pcGetpassword(this);
    }

    public void setPassword(String password) {
        User.pcSetpassword(this, password);
    }

    @Override
    public String getUsername() {
        return Person.pcGetusername(this);
    }

    @Override
    public void setUsername(String username) {
        Person.pcSetusername(this, username);
    }

    public boolean isAccountNonLocked() {
        return !User.pcGetlocked(this);
    }

    public boolean isLocked() {
        return User.pcGetlocked(this);
    }

    public void setLocked(boolean locked) {
        User.pcSetlocked(this, locked);
    }

    public boolean isCredentialsNonExpired() {
        return !User.pcGetexpired(this);
    }

    public boolean isAccountNonExpired() {
        return this.isCredentialsNonExpired();
    }

    public boolean isExpired() {
        return User.pcGetexpired(this);
    }

    public void setExpired(boolean expired) {
        User.pcSetexpired(this, expired);
    }

    public boolean isEnabled() {
        return User.pcGetenabled(this);
    }

    public void setEnabled(boolean enabled) {
        User.pcSetenabled(this, enabled);
    }

    @Override
    public String getEmail() {
        return Person.pcGetemail(this);
    }

    @Override
    public void setEmail(String email) {
        Person.pcSetemail(this, email);
    }

    public String getOpenId() {
        return User.pcGetopenId(this);
    }

    public void setOpenId(String openId) {
        User.pcSetopenId(this, openId);
    }

    public String getForgotPasswordHash() {
        return User.pcGetforgotPasswordHash(this);
    }

    public void setForgotPasswordHash(String forgotPasswordHash) {
        User.pcSetforgotPasswordHash(this, forgotPasswordHash);
    }

    public Date getForgotPasswordTime() {
        return User.pcGetforgotPasswordTime(this);
    }

    public void setForgotPasswordTime(Date forgotPasswordTime) {
        User.pcSetforgotPasswordTime(this, forgotPasswordTime);
    }

    public PageLayout getDefaultPageLayout() {
        return User.pcGetdefaultPageLayout(this);
    }

    public void setDefaultPageLayout(PageLayout defaultPageLayout) {
        User.pcSetdefaultPageLayout(this, defaultPageLayout);
    }

    public String getConfirmPassword() {
        if (this.confirmPassword != null && this.confirmPassword.length() > 0) {
            return this.confirmPassword;
        }
        return User.pcGetpassword(this);
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @PreRemove
    public void preRemove() {
        for (Authority authority : User.pcGetauthorities(this)) {
            authority.removeUser(this);
        }
        User.pcSetauthorities(this, Collections.emptyList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Person.pcGetentityId(this) == Person.pcGetentityId(other) || Person.pcGetentityId(this) != null && Person.pcGetentityId(this).equals(Person.pcGetentityId(other));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (Person.pcGetentityId(this) != null ? Person.pcGetentityId(this).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User");
        sb.append("{entityId=").append(Person.pcGetentityId(this));
        sb.append(", username='").append(Person.pcGetusername(this)).append('\'');
        sb.append(", expired=").append(User.pcGetexpired(this));
        sb.append(", locked=").append(User.pcGetlocked(this));
        sb.append(", enabled=").append(User.pcGetenabled(this));
        sb.append(", email='").append(Person.pcGetemail(this)).append('\'');
        sb.append(", openId='").append(User.pcGetopenId(this)).append('\'');
        sb.append(", authorities=[");
        boolean first = true;
        for (Authority a : User.pcGetauthorities(this)) {
            if (!first) {
                sb.append(',');
            }
            sb.append('\'').append(a.getAuthority()).append('\'');
            first = false;
        }
        sb.append(']');
        sb.append('}');
        return sb.toString();
    }

    public Person toPerson() {
        Person p = new Person();
        p.setAboutMe(this.getAboutMe());
        p.setAdditionalName(this.getAdditionalName());
        p.setAddresses(this.getAddresses());
        p.setDisplayName(this.getDisplayName());
        p.setEmail(this.getEmail());
        p.setEntityId(this.getEntityId());
        p.setFamilyName(this.getFamilyName());
        p.setFriends(this.getFriends());
        p.setGivenName(this.getGivenName());
        p.setHonorificPrefix(this.getHonorificPrefix());
        p.setHonorificSuffix(this.getHonorificSuffix());
        p.setOrganizations(this.getOrganizations());
        p.setPreferredName(this.getPreferredName());
        p.setProperties(this.getProperties());
        p.setStatus(this.getStatus());
        p.setUsername(this.getUsername());
        return p;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1055128;
    }

    static {
        Class clazz = class$Lorg$apache$rave$portal$model$Person != null ? class$Lorg$apache$rave$portal$model$Person : (class$Lorg$apache$rave$portal$model$Person = User.class$("org.apache.rave.portal.model.Person"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"authorities", "defaultPageLayout", "enabled", "expired", PARAM_FORGOT_PASSWORD_HASH, "forgotPasswordTime", "locked", "openId", "password"};
        Class[] classArray = new Class[9];
        Class clazz2 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = User.class$("java.util.Collection"));
        classArray[0] = clazz2;
        Class clazz3 = class$Lorg$apache$rave$portal$model$PageLayout != null ? class$Lorg$apache$rave$portal$model$PageLayout : (class$Lorg$apache$rave$portal$model$PageLayout = User.class$("org.apache.rave.portal.model.PageLayout"));
        classArray[1] = clazz3;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[5] = clazz5;
        classArray[6] = Boolean.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz6 = class$Lorg$apache$rave$portal$model$User != null ? class$Lorg$apache$rave$portal$model$User : (class$Lorg$apache$rave$portal$model$User = User.class$("org.apache.rave.portal.model.User"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"User", (PersistenceCapable)new User());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.authorities = null;
        this.defaultPageLayout = null;
        this.enabled = false;
        this.expired = false;
        this.forgotPasswordHash = null;
        this.forgotPasswordTime = null;
        this.locked = false;
        this.openId = null;
        this.password = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        user.pcCopyKeyFieldsFromObjectId(object);
        return user;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        return user;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + Person.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authorities = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.defaultPageLayout = (PageLayout)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.enabled = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.expired = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.forgotPasswordHash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.forgotPasswordTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.locked = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.openId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.authorities);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.defaultPageLayout);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.enabled);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.expired);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.forgotPasswordHash);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.forgotPasswordTime);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.locked);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.openId);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(User user, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(user, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authorities = user.authorities;
                return;
            }
            case 1: {
                this.defaultPageLayout = user.defaultPageLayout;
                return;
            }
            case 2: {
                this.enabled = user.enabled;
                return;
            }
            case 3: {
                this.expired = user.expired;
                return;
            }
            case 4: {
                this.forgotPasswordHash = user.forgotPasswordHash;
                return;
            }
            case 5: {
                this.forgotPasswordTime = user.forgotPasswordTime;
                return;
            }
            case 6: {
                this.locked = user.locked;
                return;
            }
            case 7: {
                this.openId = user.openId;
                return;
            }
            case 8: {
                this.password = user.password;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        User user = (User)object;
        if (user.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(user, nArray[n]);
            ++n;
        }
    }

    private static final Collection pcGetauthorities(User user) {
        if (user.pcStateManager == null) {
            return user.authorities;
        }
        int n = pcInheritedFieldCount + 0;
        user.pcStateManager.accessingField(n);
        return user.authorities;
    }

    private static final void pcSetauthorities(User user, Collection collection) {
        if (user.pcStateManager == null) {
            user.authorities = collection;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 0, user.authorities, (Object)collection, 0);
    }

    private static final PageLayout pcGetdefaultPageLayout(User user) {
        if (user.pcStateManager == null) {
            return user.defaultPageLayout;
        }
        int n = pcInheritedFieldCount + 1;
        user.pcStateManager.accessingField(n);
        return user.defaultPageLayout;
    }

    private static final void pcSetdefaultPageLayout(User user, PageLayout pageLayout) {
        if (user.pcStateManager == null) {
            user.defaultPageLayout = pageLayout;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 1, (Object)user.defaultPageLayout, (Object)pageLayout, 0);
    }

    private static final boolean pcGetenabled(User user) {
        if (user.pcStateManager == null) {
            return user.enabled;
        }
        int n = pcInheritedFieldCount + 2;
        user.pcStateManager.accessingField(n);
        return user.enabled;
    }

    private static final void pcSetenabled(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.enabled = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 2, user.enabled, bl, 0);
    }

    private static final boolean pcGetexpired(User user) {
        if (user.pcStateManager == null) {
            return user.expired;
        }
        int n = pcInheritedFieldCount + 3;
        user.pcStateManager.accessingField(n);
        return user.expired;
    }

    private static final void pcSetexpired(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.expired = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 3, user.expired, bl, 0);
    }

    private static final String pcGetforgotPasswordHash(User user) {
        if (user.pcStateManager == null) {
            return user.forgotPasswordHash;
        }
        int n = pcInheritedFieldCount + 4;
        user.pcStateManager.accessingField(n);
        return user.forgotPasswordHash;
    }

    private static final void pcSetforgotPasswordHash(User user, String string) {
        if (user.pcStateManager == null) {
            user.forgotPasswordHash = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 4, user.forgotPasswordHash, string, 0);
    }

    private static final Date pcGetforgotPasswordTime(User user) {
        if (user.pcStateManager == null) {
            return user.forgotPasswordTime;
        }
        int n = pcInheritedFieldCount + 5;
        user.pcStateManager.accessingField(n);
        return user.forgotPasswordTime;
    }

    private static final void pcSetforgotPasswordTime(User user, Date date) {
        if (user.pcStateManager == null) {
            user.forgotPasswordTime = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 5, (Object)user.forgotPasswordTime, (Object)date, 0);
    }

    private static final boolean pcGetlocked(User user) {
        if (user.pcStateManager == null) {
            return user.locked;
        }
        int n = pcInheritedFieldCount + 6;
        user.pcStateManager.accessingField(n);
        return user.locked;
    }

    private static final void pcSetlocked(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.locked = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 6, user.locked, bl, 0);
    }

    private static final String pcGetopenId(User user) {
        if (user.pcStateManager == null) {
            return user.openId;
        }
        int n = pcInheritedFieldCount + 7;
        user.pcStateManager.accessingField(n);
        return user.openId;
    }

    private static final void pcSetopenId(User user, String string) {
        if (user.pcStateManager == null) {
            user.openId = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 7, user.openId, string, 0);
    }

    private static final String pcGetpassword(User user) {
        if (user.pcStateManager == null) {
            return user.password;
        }
        int n = pcInheritedFieldCount + 8;
        user.pcStateManager.accessingField(n);
        return user.password;
    }

    private static final void pcSetpassword(User user, String string) {
        if (user.pcStateManager == null) {
            user.password = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 8, user.password, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

