/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.rave.persistence.jpa.AbstractJpaRepository;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.PageTemplate;
import org.apache.rave.portal.model.PageTemplateRegion;
import org.apache.rave.portal.model.PageTemplateWidget;
import org.apache.rave.portal.model.PageType;
import org.apache.rave.portal.model.Region;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.repository.PageRepository;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPageRepository
extends AbstractJpaRepository<Page>
implements PageRepository {
    public JpaPageRepository() {
        super(Page.class);
    }

    @Override
    public List<Page> getAllPages(Long userId, PageType pageType) {
        TypedQuery query = this.manager.createNamedQuery("Page.getByUserIdAndPageType", Page.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageType", (Object)pageType);
        return query.getResultList();
    }

    @Override
    public int deletePages(Long userId, PageType pageType) {
        TypedQuery query = this.manager.createNamedQuery("Page.deleteByUserIdAndPageType", Page.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageType", (Object)pageType);
        return query.executeUpdate();
    }

    @Override
    public boolean hasPersonPage(long userId) {
        TypedQuery query = this.manager.createNamedQuery("Page.hasPersonPage", Long.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageType", (Object)PageType.PERSON_PROFILE);
        return (Long)query.getSingleResult() > 0L;
    }

    @Override
    public Page createPersonPageForUser(User user, PageTemplate pt) {
        Page personPageFromTemplate = this.convert(pt, user);
        return (Page)this.save(personPageFromTemplate);
    }

    private Page convert(PageTemplate pt, User user) {
        Page p = new Page();
        p.setName(pt.getName());
        p.setPageType(pt.getPageType());
        p.setOwner(user);
        p.setRenderSequence(pt.getRenderSequence());
        p.setPageLayout(pt.getPageLayout());
        p.setRegions(this.convertRegions(pt.getPageTemplateRegions(), p));
        p.setSubPages(this.convertPages(pt.getSubPageTemplates(), p));
        return p;
    }

    private List<Region> convertRegions(List<PageTemplateRegion> pageTemplateRegions, Page page) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (PageTemplateRegion ptr : pageTemplateRegions) {
            Region region = new Region();
            region.setRenderOrder((int)ptr.getRenderSequence());
            region.setPage(page);
            region.setLocked(ptr.isLocked());
            region.setRegionWidgets(this.convertWidgets(ptr.getPageTemplateWidgets(), region));
            regions.add(region);
        }
        return regions;
    }

    private List<RegionWidget> convertWidgets(List<PageTemplateWidget> pageTemplateWidgets, Region region) {
        ArrayList<RegionWidget> widgets = new ArrayList<RegionWidget>();
        for (PageTemplateWidget ptw : pageTemplateWidgets) {
            RegionWidget regionWidget = new RegionWidget();
            regionWidget.setRegion(region);
            regionWidget.setCollapsed(false);
            regionWidget.setLocked(ptw.isLocked());
            regionWidget.setRenderOrder((int)ptw.getRenderSeq());
            regionWidget.setWidget(ptw.getWidget());
            widgets.add(regionWidget);
        }
        return widgets;
    }

    private List<Page> convertPages(List<PageTemplate> pageTemplates, Page page) {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (PageTemplate pt : pageTemplates) {
            Page p = new Page();
            p.setName(pt.getName());
            p.setPageType(pt.getPageType());
            p.setOwner(page.getOwner());
            p.setPageLayout(pt.getPageLayout());
            p.setParentPage(page);
            p.setRenderSequence(pt.getRenderSequence());
            p.setRegions(this.convertRegions(pt.getPageTemplateRegions(), p));
            p.setSubPages(pt.getSubPageTemplates() == null || pt.getSubPageTemplates().isEmpty() ? null : this.convertPages(pt.getSubPageTemplates(), p));
            pages.add(p);
        }
        return pages;
    }
}

