/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.persistence.jpa.AbstractJpaRepository;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.repository.UserRepository;
import org.springframework.stereotype.Repository;

@Repository
public class JpaUserRepository
extends AbstractJpaRepository<User>
implements UserRepository {
    public JpaUserRepository() {
        super(User.class);
    }

    @Override
    public User getByUsername(String username) {
        TypedQuery query = this.manager.createNamedQuery("User.getByUsername", User.class);
        query.setParameter("username", (Object)username);
        return (User)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Override
    public User getByUserEmail(String userEmail) {
        TypedQuery query = this.manager.createNamedQuery("User.getByUserEmail", User.class);
        query.setParameter("email", (Object)userEmail);
        return (User)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Override
    public List<User> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("User.getAll", User.class);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountAll() {
        Query query = this.manager.createNamedQuery("User.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<User> findByUsernameOrEmail(String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("User.findByUsernameOrEmail", User.class);
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByUsernameOrEmail(String searchTerm) {
        Query query = this.manager.createNamedQuery("User.countFindByUsernameOrEmail");
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<User> getAllByAddedWidget(long widgetId) {
        TypedQuery query = this.manager.createNamedQuery("User.getAllForAddedWidget", User.class);
        query.setParameter("widgetId", (Object)widgetId);
        return query.getResultList();
    }

    @Override
    public User getByForgotPasswordHash(String hash) {
        TypedQuery query = this.manager.createNamedQuery("User.getByForgotPasswordHash", User.class);
        query.setParameter("forgotPasswordHash", (Object)hash);
        return (User)JpaUtil.getSingleResult((List)query.getResultList());
    }
}

