/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.Category;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultCategoryPermissionEvaluator
extends AbstractModelPermissionEvaluator<Category> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private CategoryRepository categoryRepository;

    @Autowired
    public DefaultCategoryPermissionEvaluator(CategoryRepository categoryRepository) {
        this.categoryRepository = categoryRepository;
    }

    @Override
    public Class<Category> getType() {
        return Category.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Category category, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, category, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (Category)this.categoryRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, Category category, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList trustedCategoryContainer = new ArrayList();
        if (super.hasPermission(authentication, category, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case READ: {
                hasPermission = true;
                break;
            }
            case ADMINISTER: 
            case CREATE: 
            case DELETE: 
            case UPDATE: {
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private Category getTrustedCategory(long categoryId, List<Category> trustedCategoryContainer) {
        Category p = null;
        if (trustedCategoryContainer.isEmpty()) {
            p = (Category)this.categoryRepository.get(categoryId);
            trustedCategoryContainer.add(p);
        } else {
            p = trustedCategoryContainer.get(0);
        }
        return p;
    }

    private boolean isCategoryCreatedUser(Authentication authentication, Category category, List<Category> trustedCategoryContainer, boolean trustedDomainObject) {
        Category trustedCategory = null;
        trustedCategory = trustedDomainObject ? category : this.getTrustedCategory(category.getEntityId(), trustedCategoryContainer);
        return this.isCategoryCreatedUserByUsername(authentication, trustedCategory.getCreatedUser().getUsername());
    }

    private boolean isCategoryCreatedUserByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isCategoryCreatedUserById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isCategoryCreatedUserById(authentication, (Long)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }
}

