/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.rave.portal.model.NewUser;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.AuthorityService;
import org.apache.rave.portal.service.NewAccountService;
import org.apache.rave.portal.service.PageLayoutService;
import org.apache.rave.portal.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class DefaultNewAccountService
implements NewAccountService {
    private final UserService userService;
    private final PageLayoutService pageLayoutService;
    private final AuthorityService authorityService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @Autowired
    public DefaultNewAccountService(UserService userService, PageLayoutService pageLayoutService, AuthorityService authorityService) {
        this.userService = userService;
        this.pageLayoutService = pageLayoutService;
        this.authorityService = authorityService;
    }

    @Override
    public void createNewAccount(NewUser newUser) throws Exception {
        String userName = newUser.getUsername();
        String password = newUser.getPassword();
        String defaultPageLayoutCode = newUser.getPageLayout();
        String email = newUser.getEmail();
        String givenName = newUser.getFirstName();
        String familyName = newUser.getLastName();
        String displayName = newUser.getDisplayName();
        String status = newUser.getStatus();
        String aboutMe = newUser.getAboutMe();
        this.throwExceptionIfUserExists(userName, email);
        User user = new User();
        user.setUsername(userName);
        user.setEmail(email);
        String hashedPassword = this.passwordEncoder.encode((CharSequence)password);
        user.setPassword(hashedPassword);
        user.setExpired(false);
        user.setLocked(false);
        user.setEnabled(true);
        user.setDefaultPageLayout(this.pageLayoutService.getPageLayoutByCode(defaultPageLayoutCode));
        user.setAuthorities(this.authorityService.getDefaultAuthorities().getResultSet());
        user.setGivenName(givenName);
        user.setFamilyName(familyName);
        user.setDisplayName(displayName);
        user.setStatus(status);
        user.setAboutMe(aboutMe);
        this.userService.registerNewUser(user);
    }

    private void throwExceptionIfUserExists(String userName, String email) {
        User existingUser = this.userService.getUserByUsername(userName);
        if (existingUser != null) {
            throw new IllegalArgumentException("A user already exists for username " + userName);
        }
        if (StringUtils.isNotEmpty((String)email) && (existingUser = this.userService.getUserByEmail(email)) != null) {
            throw new IllegalArgumentException("A user already exists for email " + email);
        }
    }
}

