/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.rave.persistence.Repository;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.PageLayout;
import org.apache.rave.portal.model.PageType;
import org.apache.rave.portal.model.Region;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.repository.PageLayoutRepository;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.PageTemplateRepository;
import org.apache.rave.portal.repository.RegionRepository;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultPageService
implements PageService {
    private final PageRepository pageRepository;
    private final RegionRepository regionRepository;
    private final RegionWidgetRepository regionWidgetRepository;
    private final WidgetRepository widgetRepository;
    private final PageLayoutRepository pageLayoutRepository;
    private final UserService userService;
    private final PageTemplateRepository pageTemplateRepository;
    private final String defaultPageName;
    private final long MOVE_PAGE_DEFAULT_POSITION_INDEX = -1L;

    @Autowired
    public DefaultPageService(PageRepository pageRepository, PageTemplateRepository pageTemplateRepository, RegionRepository regionRepository, WidgetRepository widgetRepository, RegionWidgetRepository regionWidgetRepository, PageLayoutRepository pageLayoutRepository, UserService userService, @Value(value="${portal.page.default_name}") String defaultPageName) {
        this.pageRepository = pageRepository;
        this.pageTemplateRepository = pageTemplateRepository;
        this.regionRepository = regionRepository;
        this.regionWidgetRepository = regionWidgetRepository;
        this.widgetRepository = widgetRepository;
        this.pageLayoutRepository = pageLayoutRepository;
        this.userService = userService;
        this.defaultPageName = defaultPageName;
    }

    @Override
    public Page getPage(long pageId) {
        return (Page)this.pageRepository.get(pageId);
    }

    @Override
    public List<Page> getAllUserPages(long userId) {
        return this.pageRepository.getAllPages(userId, PageType.USER);
    }

    @Override
    @Transactional
    public Page getPersonProfilePage(long userId) {
        List<Page> profilePages = this.pageRepository.getAllPages(userId, PageType.PERSON_PROFILE);
        Page personPage = null;
        personPage = profilePages.isEmpty() ? this.pageRepository.createPersonPageForUser(this.userService.getUserById(userId), this.pageTemplateRepository.getDefaultPersonPage()) : profilePages.get(0);
        return personPage;
    }

    @Override
    public Page getPageFromList(long pageId, List<Page> pages) {
        Page pageToFind = new Page(pageId);
        int index = pages.indexOf(pageToFind);
        return index == -1 ? null : pages.get(index);
    }

    @Override
    public Page getDefaultPageFromList(List<Page> pages) {
        return pages == null || pages.isEmpty() ? null : pages.get(0);
    }

    @Override
    @Transactional
    public Page addNewUserPage(String pageName, String pageLayoutCode) {
        return this.addNewUserPage(this.userService.getAuthenticatedUser(), pageName, pageLayoutCode);
    }

    @Override
    @Transactional
    public Page addNewDefaultUserPage(long userId) {
        User user = this.userService.getUserById(userId);
        return this.addNewUserPage(user, this.defaultPageName, user.getDefaultPageLayout().getCode());
    }

    @Override
    @Transactional
    public Page addNewSubPage(String pageName, String pageLayoutCode, Page parentPage) {
        User user = this.userService.getAuthenticatedUser();
        PageLayout pageLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        ArrayList<Region> regions = new ArrayList<Region>();
        ArrayList<Page> parentsSubPages = new ArrayList<Page>();
        int regionCount = 0;
        while ((long)regionCount < pageLayout.getNumberOfRegions()) {
            Region region = new Region();
            region.setRenderOrder(regionCount);
            region.setLocked(false);
            regions.add(region);
            ++regionCount;
        }
        long renderSequence = parentPage.getSubPages() != null ? (long)(parentPage.getSubPages().size() + 1) : 1L;
        Page page = new Page();
        page.setName(pageName);
        page.setOwner(user);
        page.setPageLayout(pageLayout);
        page.setRenderSequence(renderSequence);
        page.setRegions(regions);
        page.setPageType(PageType.SUB_PAGE);
        page.setParentPage(parentPage);
        if (parentPage.getSubPages() != null) {
            parentsSubPages = parentPage.getSubPages();
        }
        parentsSubPages.add(page);
        parentPage.setSubPages(parentsSubPages);
        this.pageRepository.save(page);
        return page;
    }

    @Override
    public String getDefaultPageName() {
        return this.defaultPageName;
    }

    @Override
    @Transactional
    public void deletePage(long pageId) {
        User user = this.userService.getAuthenticatedUser();
        this.pageRepository.delete(this.pageRepository.get(pageId));
        List<Page> pages = this.pageRepository.getAllPages(user.getEntityId(), PageType.USER);
        this.updatePageRenderSequences(pages);
    }

    @Override
    @Transactional
    public int deletePages(long userId, PageType pageType) {
        return this.pageRepository.deletePages(userId, pageType);
    }

    @Override
    @Transactional
    public RegionWidget moveRegionWidget(long regionWidgetId, int newPosition, long toRegionId, long fromRegionId) {
        Region target = DefaultPageService.getFromRepository(toRegionId, this.regionRepository);
        RegionWidget regionWidget = (RegionWidget)this.regionWidgetRepository.get(regionWidgetId);
        this.verifyRegionWidgetIsNotLocked(regionWidget);
        this.verifyRegionIsNotLocked(target);
        if (toRegionId == fromRegionId) {
            this.moveWithinRegion(regionWidgetId, newPosition, target);
        } else {
            this.moveBetweenRegions(regionWidgetId, newPosition, fromRegionId, target);
        }
        target = (Region)this.regionRepository.save(target);
        return DefaultPageService.findRegionWidgetById(regionWidgetId, target.getRegionWidgets());
    }

    @Override
    @Transactional
    public RegionWidget moveRegionWidgetToPage(long regionWidgetId, long toPageId) {
        Page toPage = DefaultPageService.getFromRepository(toPageId, this.pageRepository);
        RegionWidget regionWidget = DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
        Region moveToRegion = toPage.getRegions().get(0);
        this.verifyRegionWidgetIsNotLocked(regionWidget);
        this.verifyRegionIsNotLocked(moveToRegion);
        regionWidget.setRenderOrder(0);
        regionWidget.setRegion(moveToRegion);
        moveToRegion.getRegionWidgets().add(0, regionWidget);
        DefaultPageService.updateRenderSequences(moveToRegion.getRegionWidgets());
        this.regionRepository.save(moveToRegion);
        return DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
    }

    @Override
    @Transactional
    public Region removeWidgetFromPage(long regionWidgetId) {
        RegionWidget regionWidget = DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
        this.verifyRegionWidgetIsNotLocked(regionWidget);
        this.regionWidgetRepository.delete(regionWidget);
        return DefaultPageService.getFromRepository(regionWidget.getRegion().getEntityId(), this.regionRepository);
    }

    @Override
    @Transactional
    public RegionWidget addWidgetToPage(long pageId, long widgetId) {
        Page page = DefaultPageService.getFromRepository(pageId, this.pageRepository);
        Widget widget = DefaultPageService.getFromRepository(widgetId, this.widgetRepository);
        Region region = page.getRegions().get(0);
        this.verifyRegionIsNotLocked(region);
        return this.createWidgetInstance(widget, region, 0);
    }

    @Override
    @Transactional
    public Page movePage(long pageId, long moveAfterPageId) {
        return this.doMovePage(pageId, moveAfterPageId);
    }

    @Override
    @Transactional
    public Page movePageToDefault(long pageId) {
        return this.doMovePage(pageId, -1L);
    }

    @Override
    @Transactional
    public Page updatePage(long pageId, String name, String pageLayoutCode) {
        PageLayout curLayout;
        Page page = (Page)this.pageRepository.get(pageId);
        PageLayout newLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        if (this.isLayoutAdjustmentNeeded(newLayout, curLayout = page.getPageLayout())) {
            if (curLayout.getNumberOfRegions() > newLayout.getNumberOfRegions()) {
                this.reduceRegionsForPage(page, newLayout.getNumberOfRegions());
            } else {
                long numberOfNewRegionsToAdd = newLayout.getNumberOfRegions() - curLayout.getNumberOfRegions();
                this.createAdditionalRegionsForPage(page, numberOfNewRegionsToAdd);
            }
        }
        page.setName(name);
        page.setPageLayout(newLayout);
        this.pageRepository.save(page);
        return page;
    }

    private boolean isLayoutAdjustmentNeeded(PageLayout newLayout, PageLayout curLayout) {
        return newLayout != null && !curLayout.equals(newLayout) && !curLayout.getNumberOfRegions().equals(newLayout.getNumberOfRegions());
    }

    private void createAdditionalRegionsForPage(Page page, long numberOfNewRegionsToAdd) {
        List<Region> regions = page.getRegions();
        int lastRegionRenderOrder = regions.get(regions.size() - 1).getRenderOrder() + 1;
        int i = 0;
        while ((long)i < numberOfNewRegionsToAdd) {
            Region newRegion = new Region();
            newRegion.setPage(page);
            newRegion.setRenderOrder(lastRegionRenderOrder++);
            newRegion.setLocked(false);
            regions.add(newRegion);
            ++i;
        }
    }

    private void reduceRegionsForPage(Page page, long numberOfRegionsInNewLayout) {
        List<Region> regions = page.getRegions();
        Region lastValidRegion = regions.get((int)(numberOfRegionsInNewLayout - 1L));
        while ((long)regions.size() > numberOfRegionsInNewLayout) {
            Region deletedRegion = regions.remove(regions.size() - 1);
            for (RegionWidget widget : deletedRegion.getRegionWidgets()) {
                this.moveRegionWidgetToNewRegion(widget, lastValidRegion);
            }
            this.regionRepository.delete(deletedRegion);
        }
        this.regionRepository.save(lastValidRegion);
    }

    private void moveRegionWidgetToNewRegion(RegionWidget regionWidget, Region moveToRegion) {
        List<RegionWidget> regionWidgets = moveToRegion.getRegionWidgets();
        int renderOrder = regionWidgets.isEmpty() ? 1 : regionWidgets.get(regionWidgets.size() - 1).getRenderOrder() + 1;
        regionWidget.setRegion(moveToRegion);
        regionWidget.setRenderOrder(renderOrder);
        moveToRegion.getRegionWidgets().add(regionWidget);
    }

    private RegionWidget createWidgetInstance(Widget widget, Region region, int position) {
        RegionWidget regionWidget = new RegionWidget();
        regionWidget.setRenderOrder(position);
        regionWidget.setWidget(widget);
        regionWidget.setLocked(false);
        region.getRegionWidgets().add(position, regionWidget);
        DefaultPageService.updateRenderSequences(region.getRegionWidgets());
        Region persistedRegion = (Region)this.regionRepository.save(region);
        return persistedRegion.getRegionWidgets().get(position);
    }

    private void moveWithinRegion(long regionWidgetId, int newPosition, Region target) {
        this.replaceRegionWidget(regionWidgetId, newPosition, target, target);
        DefaultPageService.updateRenderSequences(target.getRegionWidgets());
    }

    private void moveBetweenRegions(long regionWidgetId, int newPosition, long fromRegion, Region target) {
        Region source = DefaultPageService.getFromRepository(fromRegion, this.regionRepository);
        this.replaceRegionWidget(regionWidgetId, newPosition, target, source);
        DefaultPageService.updateRenderSequences(source.getRegionWidgets());
        DefaultPageService.updateRenderSequences(target.getRegionWidgets());
        this.regionRepository.save(source);
    }

    private void replaceRegionWidget(long regionWidgetId, int newPosition, Region target, Region source) {
        RegionWidget widget = DefaultPageService.findRegionWidgetById(regionWidgetId, source.getRegionWidgets());
        source.getRegionWidgets().remove(widget);
        target.getRegionWidgets().add(newPosition, widget);
    }

    private Page addNewUserPage(User user, String pageName, String pageLayoutCode) {
        PageLayout pageLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        ArrayList<Region> regions = new ArrayList<Region>();
        int regionCount = 0;
        while ((long)regionCount < pageLayout.getNumberOfRegions()) {
            Region region = new Region();
            region.setRenderOrder(regionCount);
            region.setLocked(false);
            regions.add(region);
            ++regionCount;
        }
        long renderSequence = this.getAllUserPages(user.getEntityId()).size() + 1;
        Page page = new Page();
        page.setName(pageName);
        page.setOwner(user);
        page.setPageLayout(pageLayout);
        page.setRenderSequence(renderSequence);
        page.setRegions(regions);
        page.setPageType(PageType.USER);
        this.pageRepository.save(page);
        return page;
    }

    private void updatePageRenderSequences(List<Page> pages) {
        if (pages != null && !pages.isEmpty()) {
            for (int i = 0; i < pages.size(); ++i) {
                Page p = pages.get(i);
                p.setRenderSequence((long)i + 1L);
            }
            for (Page page : pages) {
                this.pageRepository.save(page);
            }
        }
    }

    private Page doMovePage(long pageId, long moveAfterPageId) {
        ArrayList<Page> pages;
        User user = this.userService.getAuthenticatedUser();
        Page movingPage = (Page)this.pageRepository.get(pageId);
        Page afterPage = null;
        int newIndex = 0;
        if (moveAfterPageId != -1L) {
            afterPage = (Page)this.pageRepository.get(moveAfterPageId);
        }
        if (!(pages = new ArrayList<Page>(this.pageRepository.getAllPages(user.getEntityId(), PageType.USER))).remove(movingPage)) {
            throw new RuntimeException("unable to find pageId " + pageId + " attempted to be moved for user " + user);
        }
        if (afterPage != null) {
            newIndex = pages.indexOf(afterPage) + 1;
        }
        pages.add(newIndex, movingPage);
        this.updatePageRenderSequences(pages);
        return movingPage;
    }

    private static <T> T getFromRepository(long id, Repository<T> repo) {
        Object object = repo.get(id);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object of given id in " + repo.getClass().getSimpleName());
        }
        return (T)object;
    }

    private static void updateRenderSequences(List<RegionWidget> regionWidgets) {
        int count = 0;
        for (RegionWidget widget : regionWidgets) {
            widget.setRenderOrder(count);
            ++count;
        }
    }

    private static RegionWidget findRegionWidgetById(Long id, List<RegionWidget> regionWidgets) {
        for (RegionWidget widget : regionWidgets) {
            if (!widget.getEntityId().equals(id)) continue;
            return widget;
        }
        throw new IllegalArgumentException("Invalid RegionWidget ID");
    }

    private void verifyRegionIsNotLocked(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("region is null");
        }
        if (region.isLocked()) {
            throw new UnsupportedOperationException("Can't modify locked Region: " + region);
        }
    }

    private void verifyRegionWidgetIsNotLocked(RegionWidget regionWidget) {
        if (regionWidget == null) {
            throw new IllegalArgumentException("regionWidget is null");
        }
        if (regionWidget.isLocked()) {
            throw new UnsupportedOperationException("Can't modify locked RegionWidget: " + regionWidget);
        }
        this.verifyRegionIsNotLocked(regionWidget.getRegion());
    }
}

