/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.rave.portal.model.NewUser;
import org.apache.rave.portal.model.PageType;
import org.apache.rave.portal.model.Person;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.PageTemplateRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.repository.WidgetCommentRepository;
import org.apache.rave.portal.repository.WidgetRatingRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.EmailService;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userService")
public class DefaultUserService
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final UserRepository userRepository;
    private final PageRepository pageRepository;
    private final PageTemplateRepository pageTemplateRepository;
    private final WidgetRatingRepository widgetRatingRepository;
    private final WidgetCommentRepository widgetCommentRepository;
    private final WidgetRepository widgetRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private EmailService emailService;
    @Value(value="${portal.mail.passwordservice.subject}")
    private String passwordReminderSubject;
    @Value(value="${portal.mail.passwordservice.template}")
    private String passwordReminderTemplate;
    @Value(value="${portal.mail.username.subject}")
    private String userNameReminderSubject;
    @Value(value="${portal.mail.username.template}")
    private String userNameReminderTemplate;
    @Value(value="${portal.mail.service.baseurl}")
    private String baseUrl;

    @Autowired
    public DefaultUserService(PageRepository pageRepository, UserRepository userRepository, WidgetRatingRepository widgetRatingRepository, WidgetCommentRepository widgetCommentRepository, WidgetRepository widgetRepository, PageTemplateRepository pageTemplateRepository) {
        this.userRepository = userRepository;
        this.pageRepository = pageRepository;
        this.widgetRatingRepository = widgetRatingRepository;
        this.widgetCommentRepository = widgetCommentRepository;
        this.widgetRepository = widgetRepository;
        this.pageTemplateRepository = pageTemplateRepository;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        log.debug("loadUserByUsername called with: {}", (Object)username);
        User user = this.userRepository.getByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("User with username '" + username + "' was not found!");
        }
        return user;
    }

    @Override
    public User getAuthenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof User) {
            return (User)authentication.getPrincipal();
        }
        throw new SecurityException("Could not get the authenticated user!");
    }

    @Override
    public void setAuthenticatedUser(long userId) {
        User user = (User)this.userRepository.get(userId);
        if (user == null) {
            throw new UsernameNotFoundException("User with id '" + userId + "' was not found!");
        }
        SecurityContext securityContext = this.createContext(user);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    @Override
    public void clearAuthenticatedUser() {
        SecurityContextHolder.clearContext();
    }

    private SecurityContext createContext(final User user) {
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication((Authentication)new AbstractAuthenticationToken(user.getAuthorities()){
            private static final long serialVersionUID = 1L;

            public Object getCredentials() {
                return "N/A";
            }

            public Object getPrincipal() {
                return user;
            }

            public boolean isAuthenticated() {
                return true;
            }
        });
        return securityContext;
    }

    @Override
    @Transactional
    public void registerNewUser(User user) {
        User managedUser = (User)this.userRepository.save(user);
        this.pageRepository.createPersonPageForUser(managedUser, this.pageTemplateRepository.getDefaultPersonPage());
    }

    @Override
    public User getUserById(Long id) {
        return (User)this.userRepository.get(id);
    }

    @Override
    public User getUserByUsername(String userName) {
        return this.userRepository.getByUsername(userName);
    }

    @Override
    public User getUserByEmail(String userEmail) {
        return this.userRepository.getByUserEmail(userEmail);
    }

    @Override
    public void updateUserProfile(User user) {
        this.userRepository.save(user);
    }

    @Override
    public SearchResult<User> getLimitedListOfUsers(int offset, int pageSize) {
        int count = this.userRepository.getCountAll();
        List<User> users = this.userRepository.getLimitedList(offset, pageSize);
        SearchResult<User> searchResult = new SearchResult<User>(users, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<User> getUsersByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        int count = this.userRepository.getCountByUsernameOrEmail(searchTerm);
        List<User> users = this.userRepository.findByUsernameOrEmail(searchTerm, offset, pageSize);
        SearchResult<User> searchResult = new SearchResult<User>(users, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    @Transactional
    public void deleteUser(Long userId) {
        log.info("about to delete userId: " + userId);
        User user = (User)this.userRepository.get(userId);
        if (user == null) {
            log.warn("unable to find userId " + userId + " to delete");
            return;
        }
        String username = user.getUsername();
        int numDeletedPages = this.pageRepository.deletePages(userId, PageType.USER);
        int numDeletedPersonPages = this.pageRepository.deletePages(userId, PageType.PERSON_PROFILE);
        int numWidgetComments = this.widgetCommentRepository.deleteAll(userId);
        int numWidgetRatings = this.widgetRatingRepository.deleteAll(userId);
        int numWidgetsOwned = this.widgetRepository.unassignWidgetOwner(userId);
        this.userRepository.delete(user);
        log.info("Deleted user [" + userId + ',' + username + "] - numPages: " + numDeletedPages + ", numPersonPages:" + numDeletedPersonPages + ", numWidgetComments: " + numWidgetComments + ", numWidgetRatings: " + numWidgetRatings + ", numWidgetsOwned: " + numWidgetsOwned);
    }

    @Override
    public List<Person> getAllByAddedWidget(long widgetId) {
        ArrayList<Person> persons = new ArrayList<Person>();
        List<User> users = this.userRepository.getAllByAddedWidget(widgetId);
        for (User u : users) {
            persons.add(u.toPerson());
        }
        return persons;
    }

    @Override
    public void updatePassword(NewUser newUser) {
        log.debug("Changing password  for user {}", (Object)newUser);
        User user = this.userRepository.getByForgotPasswordHash(newUser.getForgotPasswordHash());
        if (user == null) {
            throw new IllegalArgumentException("Could not find user for forgotPasswordHash " + newUser.getForgotPasswordHash());
        }
        String saltedHashedPassword = this.passwordEncoder.encode((CharSequence)newUser.getPassword());
        user.setPassword(saltedHashedPassword);
        user.setForgotPasswordHash(null);
        user.setForgotPasswordTime(null);
        this.userRepository.save(user);
    }

    @Override
    public void sendUserNameReminder(NewUser newUser) {
        log.debug("Calling send username  {}", (Object)newUser);
        User user = this.userRepository.getByUserEmail(newUser.getEmail());
        if (user == null) {
            throw new IllegalArgumentException("Could not find user for email " + newUser.getEmail());
        }
        String to = user.getUsername() + " <" + user.getEmail() + '>';
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("user", user);
        this.emailService.sendEmail(to, this.userNameReminderSubject, this.userNameReminderTemplate, templateData);
    }

    @Override
    public void sendPasswordReminder(NewUser newUser) {
        log.debug("Calling send password change link for user {}", (Object)newUser);
        User user = this.userRepository.getByUserEmail(newUser.getEmail());
        if (user == null) {
            throw new IllegalArgumentException("Could not find user for email " + newUser.getEmail());
        }
        String input = user.getEmail() + user.getUsername() + String.valueOf(user.getEntityId()) + System.nanoTime();
        String safeString = new String(Base64.encode((byte[])this.passwordEncoder.encode((CharSequence)input).getBytes()));
        String hashedInput = safeString.replaceAll("[/=]", "A");
        user.setForgotPasswordHash(hashedInput);
        user.setForgotPasswordTime(Calendar.getInstance().getTime());
        this.userRepository.save(user);
        String to = user.getUsername() + " <" + user.getEmail() + '>';
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("user", user);
        templateData.put("reminderUrl", this.baseUrl + hashedInput);
        this.emailService.sendEmail(to, this.passwordReminderSubject, this.passwordReminderTemplate, templateData);
    }

    @Override
    public boolean isValidReminderRequest(String forgotPasswordHash, int nrOfMinutesValid) {
        if (StringUtils.isBlank((String)forgotPasswordHash)) {
            return false;
        }
        User userForHash = this.userRepository.getByForgotPasswordHash(forgotPasswordHash);
        if (userForHash == null) {
            return false;
        }
        Date requestTime = userForHash.getForgotPasswordTime();
        Calendar expiredDate = Calendar.getInstance();
        expiredDate.add(12, nrOfMinutesValid);
        if (requestTime == null || requestTime.after(expiredDate.getTime())) {
            userForHash.setForgotPasswordHash(null);
            userForHash.setForgotPasswordTime(null);
            this.userRepository.save(userForHash);
            return false;
        }
        return true;
    }
}

