/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import org.apache.rave.portal.model.WidgetRating;
import org.apache.rave.portal.repository.WidgetRatingRepository;
import org.apache.rave.portal.service.WidgetRatingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultWidgetRatingService
implements WidgetRatingService {
    private final WidgetRatingRepository repository;

    @Autowired
    public DefaultWidgetRatingService(WidgetRatingRepository repository) {
        this.repository = repository;
    }

    @Override
    public WidgetRating getByWidgetIdAndUserId(Long widgetId, Long userId) {
        return this.repository.getByWidgetIdAndUserId(widgetId, userId);
    }

    @Override
    @Transactional
    public void updateScore(WidgetRating widgetRating, Integer score) {
        widgetRating.setScore(score);
        this.repository.save(widgetRating);
    }

    @Override
    @Transactional
    public void saveWidgetRating(WidgetRating rating) {
        WidgetRating existingRating = this.getByWidgetIdAndUserId(rating.getWidgetId(), rating.getUserId());
        if (existingRating == null) {
            this.repository.save(rating);
        } else {
            this.updateScore(existingRating, rating.getScore());
        }
    }

    @Override
    @Transactional
    public void removeWidgetRating(Long widgetId, Long userId) {
        WidgetRating widgetRating = this.repository.getByWidgetIdAndUserId(widgetId, userId);
        if (widgetRating == null) {
            return;
        }
        this.repository.delete(widgetRating);
    }

    @Override
    @Transactional
    public int removeAllWidgetRatings(Long userId) {
        return this.repository.deleteAll(userId);
    }
}

