/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.renderer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.apache.rave.synchronization.annotation.Synchronized;
import org.springframework.stereotype.Service;

@Service
public class DefaultScriptManager
implements ScriptManager {
    private static final String KEY = "KEY";
    private final Map<ScriptLocation, List<String>> scriptRenderers = new HashMap<ScriptLocation, List<String>>();

    @Override
    public List<String> getScriptBlocks(ScriptLocation location, RenderContext context) {
        LinkedList<String> combined = new LinkedList<String>();
        DefaultScriptManager.getAndAdd(location, combined, this.scriptRenderers);
        DefaultScriptManager.getAndAdd(location, combined, DefaultScriptManager.getOrCreateScriptMap(context));
        return combined;
    }

    @Override
    public void registerScriptBlock(String script, ScriptLocation location) {
        DefaultScriptManager.addScriptToMap(script, location, this.scriptRenderers);
    }

    @Override
    public void registerScriptBlock(String script, ScriptLocation location, RenderScope scope, RenderContext context) {
        switch (scope) {
            case GLOBAL: {
                this.registerScriptBlock(script, location);
                break;
            }
            case CURRENT_REQUEST: {
                DefaultScriptManager.addScriptToContext(script, location, context);
                break;
            }
            default: {
                throw new NotSupportedException("The scope, " + (Object)((Object)scope) + " , is not supported by the script manager");
            }
        }
    }

    private static void getAndAdd(ScriptLocation location, List<String> output, Map<ScriptLocation, List<String>> map) {
        List<String> scripts = map.get((Object)location);
        if (scripts != null) {
            output.addAll(scripts);
        }
    }

    private static void addScriptToContext(String script, ScriptLocation location, RenderContext context) {
        Map<ScriptLocation, List<String>> scriptMap = DefaultScriptManager.getOrCreateScriptMap(context);
        DefaultScriptManager.addScriptToMap(script, location, scriptMap);
    }

    private static void addScriptToMap(String script, ScriptLocation location, Map<ScriptLocation, List<String>> scripts) {
        if (!scripts.containsKey((Object)location)) {
            DefaultScriptManager.addListForLocation(location, scripts);
        }
        scripts.get((Object)location).add(script);
    }

    @Synchronized(discriminator="'SM_#map.toString()'", id="#location")
    private static void addListForLocation(ScriptLocation location, Map<ScriptLocation, List<String>> map) {
        if (!map.containsKey((Object)location)) {
            map.put(location, new ArrayList());
        }
    }

    private static Map<ScriptLocation, List<String>> getOrCreateScriptMap(RenderContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot have a null render context");
        }
        HashMap scriptMap = (HashMap)context.getProperties().get(KEY);
        if (scriptMap == null) {
            scriptMap = new HashMap();
            context.getProperties().put(KEY, scriptMap);
        }
        return scriptMap;
    }
}

