/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import java.util.List;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PageController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;
    private UserService userService;

    @Autowired
    public PageController(PageService pageService, UserService userService) {
        this.pageService = pageService;
        this.userService = userService;
    }

    @RequestMapping(value={"/page/view", "/index.html"}, method={RequestMethod.GET})
    public String viewDefault(Model model) {
        User user = this.userService.getAuthenticatedUser();
        List pages = this.pageService.getAllPages(user.getEntityId().longValue());
        model.addAttribute("page", pages.get(0));
        model.addAttribute("pages", (Object)pages);
        return "home";
    }

    @RequestMapping(value={"/page/view/{pageId}"}, method={RequestMethod.GET})
    public String view(@PathVariable Long pageId, Model model) {
        User user = this.userService.getAuthenticatedUser();
        this.logger.debug("attempting to get pageId " + pageId + " for " + user);
        List pages = this.pageService.getAllPages(user.getEntityId().longValue());
        Page page = this.pageService.getPageFromList(pageId.longValue(), pages);
        model.addAttribute("page", (Object)page);
        model.addAttribute("pages", (Object)pages);
        return "home";
    }
}

