/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.validator.NewWidgetValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/store/*", "/store"})
public class WidgetStoreController {
    private static final int MAXIMUM_WIDGETS_PER_PAGE = 10;
    private final WidgetService widgetService;
    private final NewWidgetValidator widgetValidator;

    @Autowired
    public WidgetStoreController(WidgetService widgetService, NewWidgetValidator validator) {
        this.widgetService = widgetService;
        this.widgetValidator = validator;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @RequestParam long referringPageId, @RequestParam(required=false, defaultValue="0") int offset) {
        model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgets(offset, 10));
        model.addAttribute("referringPageId", (Object)referringPageId);
        return "store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/{widgetId}"})
    public String viewWidget(Model model, @PathVariable long widgetId, @RequestParam long referringPageId) {
        model.addAttribute("widget", (Object)this.widgetService.getWidget(widgetId));
        model.addAttribute("referringPageId", (Object)referringPageId);
        return "widget";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"search"})
    public String viewSearchResult(Model model, @RequestParam long referringPageId, @RequestParam String searchTerm, @RequestParam(required=false, defaultValue="0") int offset) {
        model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgetsByFreeTextSearch(searchTerm, offset, 10));
        model.addAttribute("referringPageId", (Object)referringPageId);
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("offset", (Object)offset);
        return "store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/add"})
    public String viewAddWidgetForm(Model model) {
        Widget widget = new Widget();
        model.addAttribute("widget", (Object)widget);
        return "addwidget";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"widget/add"})
    public String viewAddWidgetResult(@ModelAttribute Widget widget, BindingResult results, Model model) {
        this.widgetValidator.validate(widget, (Errors)results);
        if (results.hasErrors()) {
            model.addAttribute("widget", (Object)widget);
            return "addwidget";
        }
        widget.setWidgetStatus(WidgetStatus.PREVIEW);
        Widget storedWidget = this.widgetService.registerNewWidget(widget);
        if (storedWidget == null) {
            results.reject("page.addwidget.result.exists");
            model.addAttribute("widget", (Object)widget);
            return "addwidget";
        }
        model.addAttribute("widget", (Object)storedWidget);
        return "widget";
    }
}

