/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.model.RegionWidgetPreference;
import org.apache.rave.portal.service.RegionWidgetService;
import org.apache.rave.portal.web.api.rest.AbstractRestApi;
import org.apache.rave.portal.web.model.RegionWidgetPreferenceListWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/rest/regionWidgets"})
public class RegionWidgetApi
extends AbstractRestApi {
    private static Logger logger = LoggerFactory.getLogger(RegionWidgetApi.class);
    private RegionWidgetService regionWidgetService;

    @Autowired
    public RegionWidgetApi(RegionWidgetService regionWidgetService) {
        this.regionWidgetService = regionWidgetService;
    }

    @ResponseBody
    @RequestMapping(value={"/{regionWidgetId}/preferences"}, method={RequestMethod.PUT})
    public RegionWidgetPreferenceListWrapper replaceAllRegionWidgetPreferences(@PathVariable long regionWidgetId, @RequestBody RegionWidgetPreferenceListWrapper regionWidgetPreferenceListWrapper) {
        if (logger.isDebugEnabled()) {
            logger.debug("PUT received to replace all preferences for regionWidget: " + regionWidgetId + " with data: " + regionWidgetPreferenceListWrapper);
        }
        List regionWidgetPreferences = this.regionWidgetService.saveRegionWidgetPreferences(regionWidgetId, regionWidgetPreferenceListWrapper.getPreferences());
        return new RegionWidgetPreferenceListWrapper(regionWidgetPreferences);
    }

    @ResponseBody
    @RequestMapping(value={"/{regionWidgetId}/preferences/{regionWidgetPreferenceName}"}, method={RequestMethod.PUT})
    public RegionWidgetPreference createOrReplaceRegionWidgetPreference(@PathVariable long regionWidgetId, @PathVariable String regionWidgetPreferenceName, @RequestBody RegionWidgetPreference regionWidgetPreference) {
        if (logger.isDebugEnabled()) {
            logger.debug("PUT received to create or replace preference: " + regionWidgetPreferenceName + " for regionWidget: " + regionWidgetId + " with data: " + regionWidgetPreference);
        }
        Validate.isTrue((boolean)regionWidgetPreferenceName.equalsIgnoreCase(regionWidgetPreference.getName()), (String)"The preference name in the URL does not match the preference name in the RegionWidgetPreference object.");
        return this.regionWidgetService.saveRegionWidgetPreference(regionWidgetId, regionWidgetPreference);
    }

    @ResponseBody
    @RequestMapping(value={"/{regionWidgetId}/collapsed"}, method={RequestMethod.PUT})
    public RegionWidget updateRegionWidgetCollapsedStatus(@PathVariable long regionWidgetId, @RequestBody Boolean collapsed) {
        if (logger.isDebugEnabled()) {
            logger.debug("POST received to update regionWidget " + regionWidgetId + ": " + collapsed);
        }
        return this.regionWidgetService.saveRegionWidgetCollapsedState(regionWidgetId, collapsed.booleanValue());
    }
}

