/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import javax.servlet.http.HttpServletResponse;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetRatingService;
import org.apache.rave.portal.web.api.rest.AbstractRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/rest/widgets"})
public class WidgetApi
extends AbstractRestApi {
    private static Logger logger = LoggerFactory.getLogger(WidgetApi.class);
    private final WidgetRatingService widgetRatingService;
    private final UserService userService;

    @Autowired
    public WidgetApi(WidgetRatingService widgetRatingService, UserService userService) {
        this.widgetRatingService = widgetRatingService;
        this.userService = userService;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void getAllWidgets() {
        logger.debug("GET received for all widgets");
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @RequestMapping(value={"/{widgetId}/rating"}, method={RequestMethod.DELETE})
    public void deleteWidgetRating(@PathVariable long widgetId, HttpServletResponse response) {
        logger.debug("DELETE WidgetRating received for /api/rest/widgets/{}", (Object)widgetId);
        this.widgetRatingService.removeWidgetRating(Long.valueOf(widgetId), this.userService.getAuthenticatedUser().getEntityId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/{widgetId}/rating"}, method={RequestMethod.POST})
    public void setWidgetRating(@PathVariable long widgetId, @RequestParam(value="score") Integer score, HttpServletResponse response) {
        logger.debug("POST WidgetRating received for /api/rest/widgets/{} score: {}", (Object)widgetId, (Object)score);
        this.widgetRatingService.saveWidgetRating(Long.valueOf(widgetId), score, this.userService.getAuthenticatedUser().getEntityId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

