/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc.model;

public class RpcResult<T> {
    private boolean error;
    private String errorMessage;
    private ErrorCode errorCode;
    private T result;

    public RpcResult(boolean error) {
        this.error = error;
        this.setDefaultCode(error);
    }

    public RpcResult(boolean error, T result) {
        this.error = error;
        this.result = result;
        this.setDefaultCode(error);
    }

    public RpcResult(boolean error, String errorMessage, ErrorCode errorCode) {
        this.error = error;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    public RpcResult(boolean error, String errorMessage, ErrorCode errorCode, T result) {
        this.error = error;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.result = result;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    private void setDefaultCode(boolean error) {
        this.errorCode = error ? ErrorCode.INTERNAL_ERROR : ErrorCode.NO_ERROR;
    }

    public static enum ErrorCode {
        NO_ERROR,
        INVALID_PARAMS,
        INTERNAL_ERROR,
        DUPLICATE_ITEM;

    }
}

