/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.apache.rave.portal.model.Authority;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.service.AuthorityService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.apache.rave.portal.web.validator.UserProfileValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"user", "tokencheck"})
public class UserController {
    private static final String SELECTED_ITEM = "users";
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorityService authorityService;
    @Autowired
    private UserProfileValidator userProfileValidator;

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(Authority.class, (PropertyEditor)new AuthorityEditor());
        dataBinder.setDisallowedFields(new String[]{"entityId", "username", "password", "confirmPassword"});
    }

    @RequestMapping(value={"/admin/users"}, method={RequestMethod.GET})
    public String viewUsers(@RequestParam(required=false, defaultValue="0") int offset, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        SearchResult users = this.userService.getLimitedListOfUsers(offset, 10);
        model.addAttribute("searchResult", (Object)users);
        return "admin/users";
    }

    @RequestMapping(value={"/admin/users/search"}, method={RequestMethod.GET})
    public String searchUsers(@RequestParam(required=true) String searchTerm, @RequestParam(required=false, defaultValue="0") int offset, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        SearchResult users = this.userService.getUsersByFreeTextSearch(searchTerm, offset, 10);
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("searchResult", (Object)users);
        return "admin/users";
    }

    @RequestMapping(value={"/admin/userdetail/{userid}"}, method={RequestMethod.GET})
    public String viewUserDetail(@PathVariable(value="userid") Long userid, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        model.addAttribute((Object)this.userService.getUserById(userid));
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        return "admin/userdetail";
    }

    @RequestMapping(value={"/admin/userdetail/update"}, method={RequestMethod.POST})
    public String updateUserDetail(@ModelAttribute(value="user") User user, BindingResult result, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        this.userProfileValidator.validate(user, (Errors)result);
        if (result.hasErrors()) {
            return "admin/userdetail";
        }
        this.userService.updateUserProfile(user);
        status.setComplete();
        return "redirect:" + user.getEntityId();
    }

    @ModelAttribute(value="authorities")
    public SearchResult<Authority> populateAuthorityList() {
        return this.authorityService.getAllAuthorities();
    }

    @ModelAttribute(value="loggedInUser")
    public String populateLoggedInUsername() {
        return this.userService.getAuthenticatedUser().getUsername();
    }

    void setUserService(UserService userService) {
        this.userService = userService;
    }

    void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    void setUserProfileValidator(UserProfileValidator userProfileValidator) {
        this.userProfileValidator = userProfileValidator;
    }

    private class AuthorityEditor
    extends PropertyEditorSupport {
        private AuthorityEditor() {
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            Authority authority = UserController.this.authorityService.getAuthorityByName(text);
            this.setValue(authority);
        }
    }
}

