/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.rave.portal.model.NewUser;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class NewAccountValidator
implements Validator {
    private static final int MINIMUM_PASSWORD_LENGTH = 4;
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_PASSWORD = "password";
    private static final String FIELD_CONFIRM_PASSWORD = "confirmPassword";
    private static final String FIELD_EMAIL = "email";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String USERNAME_PATTERN = "[\\w\\+\\-\\.@]{2,}";
    private UserService userService;

    @Autowired
    public NewAccountValidator(UserService userService) {
        this.userService = userService;
    }

    public boolean supports(Class aClass) {
        return NewUser.class.isAssignableFrom(aClass);
    }

    public void validate(Object obj, Errors errors) {
        this.logger.debug("Validator called");
        NewUser newUser = (NewUser)obj;
        this.validateUsername(errors, newUser);
        this.validatePassword(errors, newUser);
        this.validateConfirmPassword(errors, newUser);
        this.validateEmail(errors, newUser.getEmail());
        this.writeResultToLog(errors);
    }

    private void validateUsername(Errors errors, NewUser newUser) {
        String username = newUser.getUsername();
        if (StringUtils.isBlank((String)username)) {
            errors.rejectValue(FIELD_USERNAME, "username.required");
            this.logger.info("Username required");
        } else if (!username.matches(USERNAME_PATTERN)) {
            errors.rejectValue(FIELD_USERNAME, "username.invalid.pattern");
            this.logger.info("Username has invalid pattern");
        } else if (this.isExistingUsername(username)) {
            errors.rejectValue(FIELD_USERNAME, "username.exists");
            this.logger.info("Username already exists");
        }
    }

    private boolean isExistingUsername(String username) {
        return this.userService.getUserByUsername(username) != null;
    }

    private void validatePassword(Errors errors, NewUser newUser) {
        if (StringUtils.isBlank((String)newUser.getPassword())) {
            errors.rejectValue(FIELD_PASSWORD, "password.required");
            this.logger.info("Password required");
        } else if (newUser.getPassword().length() < 4) {
            errors.rejectValue(FIELD_PASSWORD, "password.invalid.length");
            this.logger.info("Password must be at least {} characters long", (Object)4);
        }
    }

    private void validateConfirmPassword(Errors errors, NewUser newUser) {
        if (StringUtils.isBlank((String)newUser.getConfirmPassword())) {
            errors.rejectValue(FIELD_CONFIRM_PASSWORD, "confirmPassword.required");
            this.logger.info("Confirm Password required");
        } else if (this.isConfirmPasswordDifferentThanPassword(newUser)) {
            errors.rejectValue(FIELD_CONFIRM_PASSWORD, "confirmPassword.mismatch");
            this.logger.info("Password mismatch");
        }
    }

    private boolean isConfirmPasswordDifferentThanPassword(NewUser newUser) {
        return !newUser.getConfirmPassword().equals(newUser.getPassword());
    }

    private void validateEmail(Errors errors, String email) {
        if (StringUtils.isBlank((String)email)) {
            errors.rejectValue(FIELD_EMAIL, "email.required");
        } else if (this.isInvalidEmailAddress(email)) {
            errors.rejectValue(FIELD_EMAIL, "email.invalid");
        } else if (this.isExistingEmailAddress(email)) {
            errors.rejectValue(FIELD_EMAIL, "email.exists");
        }
    }

    private boolean isInvalidEmailAddress(String emailAddress) {
        return !EmailValidator.getInstance().isValid(emailAddress);
    }

    private boolean isExistingEmailAddress(String email) {
        return this.userService.getUserByEmail(email) != null;
    }

    private void writeResultToLog(Errors errors) {
        if (errors.hasErrors()) {
            if (this.logger.isInfoEnabled()) {
                for (ObjectError error : errors.getAllErrors()) {
                    this.logger.info("Validation error: {}", (Object)error.toString());
                }
            }
        } else {
            this.logger.debug("Validation successful");
        }
    }
}

