/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.UrlValidator;
import org.apache.rave.portal.model.Widget;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class NewWidgetValidator
implements Validator {
    private static final String FIELD_URL = "url";
    private UrlValidator validator;

    public NewWidgetValidator() {
        String[] allowedSchemes = new String[]{"http", "https"};
        this.validator = new UrlValidator(allowedSchemes);
    }

    public boolean supports(Class<?> clazz) {
        return Widget.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Widget widget = (Widget)target;
        this.validateRequiredFields(errors);
        this.validateUrlFields(widget, errors);
    }

    private void validateRequiredFields(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"widget.title.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)FIELD_URL, (String)"widget.url.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"type", (String)"widget.type.required");
    }

    private void validateUrlFields(Widget widget, Errors errors) {
        String titleUrl;
        String thumbnailUrl;
        String screenshotUrl;
        String url = widget.getUrl();
        if (StringUtils.isNotBlank((String)url) && !this.validator.isValid(url)) {
            errors.rejectValue(FIELD_URL, "widget.url.malformed");
        }
        if (StringUtils.isNotBlank((String)(screenshotUrl = widget.getScreenshotUrl())) && !this.validator.isValid(screenshotUrl)) {
            errors.rejectValue("screenshotUrl", "widget.screenshotUrl.malformed");
        }
        if (StringUtils.isNotBlank((String)(thumbnailUrl = widget.getThumbnailUrl())) && !this.validator.isValid(thumbnailUrl)) {
            errors.rejectValue("thumbnailUrl", "widget.thumbnailUrl.malformed");
        }
        if (StringUtils.isNotBlank((String)(titleUrl = widget.getTitleUrl())) && !this.validator.isValid(titleUrl)) {
            errors.rejectValue("titleUrl", "widget.titleUrl.malformed");
        }
    }
}

