/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.rave.portal.web.model.NavigationItem;
import org.apache.rave.portal.web.model.NavigationMenu;
import org.springframework.ui.Model;
import org.springframework.web.bind.support.SessionStatus;

public final class AdminControllerUtil {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final int TOKEN_LENGTH = 256;

    private AdminControllerUtil() {
    }

    static String generateSessionToken() {
        return RandomStringUtils.randomAlphanumeric((int)256);
    }

    public static void checkTokens(String sessionToken, String token, SessionStatus status) {
        if (StringUtils.length((String)sessionToken) != 256 || !sessionToken.equals(token)) {
            status.setComplete();
            throw new SecurityException("Token does not match");
        }
    }

    static boolean isDeleteOrUpdate(String action) {
        return "update".equals(action) || "delete".equals(action);
    }

    static void addNavigationMenusToModel(String selectedItem, Model model) {
        NavigationMenu topMenu = AdminControllerUtil.getTopMenu();
        model.addAttribute(topMenu.getName(), (Object)topMenu);
        NavigationMenu tabMenu = AdminControllerUtil.getTabMenu(selectedItem);
        model.addAttribute(tabMenu.getName(), (Object)tabMenu);
    }

    private static NavigationMenu getTopMenu() {
        NavigationMenu menu = new NavigationMenu("topnav");
        NavigationItem raveHome = new NavigationItem("page.general.back", "/");
        menu.addNavigationItem(raveHome);
        NavigationItem logout = new NavigationItem("page.general.logout", "/j_spring_security_logout");
        menu.addNavigationItem(logout);
        return menu;
    }

    private static NavigationMenu getTabMenu(String selectedItem) {
        NavigationMenu menu = new NavigationMenu("tabs");
        NavigationItem home = new NavigationItem("admin.home.shorttitle", "/app/admin/");
        home.setSelected("home".equals(selectedItem));
        menu.addNavigationItem(home);
        NavigationItem users = new NavigationItem("admin.users.shorttitle", "/app/admin/users");
        users.setSelected("users".equals(selectedItem));
        menu.addNavigationItem(users);
        NavigationItem widgets = new NavigationItem("admin.widgets.shorttitle", "/app/admin/widgets");
        widgets.setSelected("widgets".equals(selectedItem));
        menu.addNavigationItem(widgets);
        NavigationItem preferences = new NavigationItem("admin.preferences.shorttitle", "/app/admin/preferences");
        preferences.setSelected("preferences".equals(selectedItem));
        menu.addNavigationItem(preferences);
        return menu;
    }
}

