/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.apache.rave.portal.web.validator.UpdateWidgetValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"widget", "tokencheck"})
public class WidgetController {
    private static final String SELECTED_ITEM = "widgets";
    @Autowired
    private WidgetService widgetService;
    @Autowired
    private UpdateWidgetValidator widgetValidator;

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"entityId"});
    }

    @RequestMapping(value={"/admin/widgets"}, method={RequestMethod.GET})
    public String viewWidgets(@RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false) String action, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        SearchResult widgets = this.widgetService.getLimitedListOfWidgets(offset, 10);
        model.addAttribute("searchResult", (Object)widgets);
        if (AdminControllerUtil.isDeleteOrUpdate(action)) {
            model.addAttribute("actionresult", (Object)action);
        }
        return "admin/widgets";
    }

    @RequestMapping(value={"/admin/widgets/search"}, method={RequestMethod.GET})
    public String searchWidgets(@RequestParam(required=false) String searchTerm, @RequestParam(required=false) String widgettype, @RequestParam(required=false) String widgetstatus, @RequestParam(required=false, defaultValue="0") int offset, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        SearchResult widgets = this.widgetService.getWidgetsBySearchCriteria(searchTerm, widgettype, widgetstatus, offset, 10);
        model.addAttribute("searchResult", (Object)widgets);
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("selectedWidgetType", (Object)widgettype);
        model.addAttribute("selectedWidgetStatus", (Object)widgetstatus);
        return "admin/widgets";
    }

    @RequestMapping(value={"/admin/widgetdetail/{widgetid}"}, method={RequestMethod.GET})
    public String viewWidgetDetail(@PathVariable(value="widgetid") Long widgetid, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        model.addAttribute((Object)this.widgetService.getWidget(widgetid.longValue()));
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        return "admin/widgetdetail";
    }

    @RequestMapping(value={"/admin/widgetdetail/update"}, method={RequestMethod.POST})
    public String updateWidgetDetail(@ModelAttribute(value="widget") Widget widget, BindingResult result, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, ModelMap modelMap, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        this.widgetValidator.validate(widget, (Errors)result);
        if (result.hasErrors()) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, (Model)modelMap);
            return "admin/widgetdetail";
        }
        this.widgetService.updateWidget(widget);
        modelMap.clear();
        status.setComplete();
        return "redirect:/app/admin/widgets?action=update";
    }

    @ModelAttribute(value="widgetStatus")
    public WidgetStatus[] getWidgetStatusValues() {
        return WidgetStatus.values();
    }

    void setWidgetService(WidgetService widgetService) {
        this.widgetService = widgetService;
    }

    void setWidgetValidator(UpdateWidgetValidator widgetValidator) {
        this.widgetValidator = widgetValidator;
    }
}

