/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.NewUser;
import org.apache.rave.portal.service.NewAccountService;
import org.apache.rave.portal.web.validator.NewAccountValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class NewAccountController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NewAccountService newAccountService;
    private final NewAccountValidator newAccountValidator;

    @Autowired
    public NewAccountController(NewAccountService newAccountService, NewAccountValidator newAccountValidator) {
        this.newAccountService = newAccountService;
        this.newAccountValidator = newAccountValidator;
    }

    @RequestMapping(value={"/newaccount.jsp"})
    public void setUpForm(ModelMap model) {
        this.logger.debug("Initializing form");
        model.addAttribute("newUser", (Object)new NewUser());
    }

    @RequestMapping(value={"/newaccount", "/newacount/*"}, method={RequestMethod.POST})
    public String create(@ModelAttribute NewUser newUser, BindingResult results, Model model) {
        this.logger.debug("Creating a new user account");
        model.addAttribute("newUser", (Object)newUser);
        this.newAccountValidator.validate(newUser, (Errors)results);
        if (results.hasErrors()) {
            this.logger.info("newaccount.jsp: shows validation errors");
            return "templates.user.newaccount";
        }
        try {
            this.logger.debug("newaccount.jsp: passed form validation");
            this.newAccountService.createNewAccount(newUser);
            return "redirect:/";
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            this.logger.info("Account creation failed: ", (Throwable)ex);
            results.reject("Account already exists", "Unable to create account");
            return "templates.user.newaccount";
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error("Account creation failed: ", (Throwable)ex);
            } else {
                this.logger.error("Account creation failed: {}", (Object)ex.getMessage());
            }
            results.reject("Unable to create account:" + ex.getMessage(), "Unable to create account");
            return "templates.user.newaccount";
        }
    }
}

