/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.model;

import java.util.Map;
import org.apache.rave.portal.model.PortalPreference;

public class PortalPreferenceForm {
    public static final String DEFAULT_PAGE_SIZE = "10";
    public static final String DEFAULT_TITLE_SUFFIX = "";
    private Map<String, PortalPreference> preferenceMap;

    public PortalPreferenceForm(Map<String, PortalPreference> preferenceMap) {
        this.preferenceMap = preferenceMap;
        this.populateMissingPreferences();
    }

    private void populateMissingPreferences() {
        if (this.getPageSize() == null) {
            this.preferenceMap.put("pageSize", new PortalPreference("pageSize", DEFAULT_PAGE_SIZE));
        }
        if (this.getTitleSuffix() == null) {
            this.preferenceMap.put("titleSuffix", new PortalPreference("titleSuffix", DEFAULT_TITLE_SUFFIX));
        }
    }

    public PortalPreference getPageSize() {
        return this.preferenceMap.get("pageSize");
    }

    public void setPageSize(PortalPreference pageSize) {
        this.preferenceMap.put("pageSize", pageSize);
    }

    public PortalPreference getTitleSuffix() {
        return this.preferenceMap.get("titleSuffix");
    }

    public void setTitleSuffix(PortalPreference titleSuffix) {
        this.preferenceMap.put("titleSuffix", titleSuffix);
    }

    public Map<String, PortalPreference> getPreferenceMap() {
        return this.preferenceMap;
    }

    public void setPreferenceMap(Map<String, PortalPreference> preferenceMap) {
        this.preferenceMap = preferenceMap;
    }
}

