/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.service.WidgetMetadataResolver;
import org.apache.rave.portal.web.api.rpc.model.RpcOperation;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="rpcWidgetApi")
@RequestMapping(value={"/api/rpc/widget/*"})
public class WidgetApi {
    private Map<String, WidgetMetadataResolver> widgetMetadataResolverMap = new HashMap<String, WidgetMetadataResolver>();

    @Autowired
    public WidgetApi(List<WidgetMetadataResolver> widgetMetadataResolvers) {
        for (WidgetMetadataResolver widgetMetadataResolver : widgetMetadataResolvers) {
            this.widgetMetadataResolverMap.put(widgetMetadataResolver.getSupportedContext(), widgetMetadataResolver);
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"metadata/get"})
    public RpcResult<Widget> getWidgetMetadata(final @RequestParam String url, final @RequestParam String type) {
        return new RpcOperation<Widget>(){

            @Override
            public Widget execute() {
                if (WidgetApi.this.widgetMetadataResolverMap.get(type) == null) {
                    throw new IllegalArgumentException("Get Metadata for provider " + type + " is not implemented");
                }
                return ((WidgetMetadataResolver)WidgetApi.this.widgetMetadataResolverMap.get(type)).getMetadata(url);
            }
        }.getResult();
    }
}

