/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/userInfo/*", "/userInfo", "/userInfo/"})
public class ProfileController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UserService userService;

    @Autowired
    public ProfileController(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String setUpForm(ModelMap model, @RequestParam long referringPageId) {
        this.logger.debug("Initializing User Info page");
        User user = this.userService.getAuthenticatedUser();
        this.addAttributesToModel(model, user, referringPageId, "aboutTagPage");
        return "templates.user.profile";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateUserProfile(ModelMap model, @RequestParam long referringPageId, @ModelAttribute(value="updatedUser") User updatedUser) {
        this.logger.debug("Updating User's profile information");
        User user = this.userService.getAuthenticatedUser();
        user.setGivenName(updatedUser.getGivenName());
        user.setFamilyName(updatedUser.getFamilyName());
        user.setDisplayName(updatedUser.getDisplayName());
        user.setAboutMe(updatedUser.getAboutMe());
        user.setStatus(updatedUser.getStatus());
        user.setEmail(updatedUser.getEmail());
        this.userService.updateUserProfile(user);
        this.addAttributesToModel(model, user, referringPageId, "aboutTagPage");
        return "templates.user.profile";
    }

    private void addAttributesToModel(ModelMap model, User user, long referringPageId, String defaultTagPage) {
        model.addAttribute("userProfile", (Object)user);
        model.addAttribute("referringPageId", (Object)referringPageId);
        model.addAttribute("defaultTagPage", (Object)defaultTagPage);
    }
}

