/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.validator.UserProfileValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class UserProfileController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UserService userService;
    private final UserProfileValidator userProfileValidator;

    @Autowired
    public UserProfileController(UserService userService, UserProfileValidator userProfileValidator) {
        this.userService = userService;
        this.userProfileValidator = userProfileValidator;
    }

    @RequestMapping(value={"/userProfile.jsp"})
    public void setUpForm(ModelMap model) {
        this.logger.debug("Initializing form");
        User user = this.userService.getAuthenticatedUser();
        model.addAttribute("userProfile", (Object)user);
    }

    @RequestMapping(value={"/updateUserProfile", "/updateUserProfile/*"}, method={RequestMethod.POST})
    public String create(@ModelAttribute User user, BindingResult results, Model model, @RequestParam String username, @RequestParam String password) {
        this.logger.debug("Updating user profile.");
        model.addAttribute("userProfile", (Object)user);
        this.userProfileValidator.validate(user, (Errors)results);
        if (results.hasErrors()) {
            this.logger.info("userProfile.jsp: shows validation errors");
            return "templates.user.userProfile";
        }
        try {
            this.logger.debug("userprofile: passed form validation");
            this.userService.updateUserProfile(user);
            return "redirect:/";
        }
        catch (Exception ex) {
            this.logger.info("Account creation failed: {}", (Object)ex.getMessage());
            results.reject("Unable to create account:" + ex.getMessage(), "Unable to create account");
            return "templates.user.userProfile";
        }
    }
}

