/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.PortalPreference;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.TagService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.validator.NewWidgetValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/store/*", "/store"})
public class WidgetStoreController {
    private static final int MAXIMUM_WIDGETS_PER_PAGE = 10;
    private final WidgetService widgetService;
    private final NewWidgetValidator widgetValidator;
    private final UserService userService;
    private final PortalPreferenceService preferenceService;
    private final TagService tagService;
    private final CategoryService categoryService;

    @Autowired
    public WidgetStoreController(WidgetService widgetService, NewWidgetValidator validator, UserService userService, PortalPreferenceService preferenceService, TagService tagService, CategoryService categoryService) {
        this.widgetService = widgetService;
        this.widgetValidator = validator;
        this.userService = userService;
        this.preferenceService = preferenceService;
        this.tagService = tagService;
        this.categoryService = categoryService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @RequestParam long referringPageId, @RequestParam(required=false, defaultValue="0") int offset) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user);
        model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgets(offset, this.getPageSize()));
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"mine"})
    public String viewMine(Model model, @RequestParam long referringPageId, @RequestParam(required=false, defaultValue="0") int offset) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user);
        model.addAttribute("widgets", (Object)this.widgetService.getWidgetsByOwner(user.getEntityId(), offset, this.getPageSize()));
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/{widgetId}"})
    public String viewWidget(Model model, @PathVariable long widgetId, @RequestParam long referringPageId) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user);
        model.addAttribute("widget", (Object)this.widgetService.getWidget(widgetId));
        model.addAttribute("widgetStatistics", (Object)this.widgetService.getWidgetStatistics(widgetId, user.getEntityId().longValue()));
        model.addAttribute("userProfile", (Object)user);
        return "templates.user.widget";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"search"})
    public String viewSearchResult(Model model, @RequestParam long referringPageId, @RequestParam String searchTerm, @RequestParam(required=false, defaultValue="0") int offset) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user);
        model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgetsByFreeTextSearch(searchTerm, offset, this.getPageSize()));
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("offset", (Object)offset);
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"tag"})
    public String viewTagResult(Model model, @RequestParam long referringPageId, @RequestParam String keyword, @RequestParam(required=false, defaultValue="0") int offset) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user);
        model.addAttribute("widgets", (Object)this.widgetService.getWidgetsByTag(keyword, offset, this.getPageSize()));
        model.addAttribute("offset", (Object)offset);
        model.addAttribute("selectedTag", (Object)keyword);
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"category"})
    public String viewCategoryResult(@RequestParam(required=true) long referringPageId, @RequestParam(required=true) long categoryId, @RequestParam(required=false, defaultValue="0") int offset, Model model) {
        User authenticatedUser = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, authenticatedUser);
        if (categoryId > 0L) {
            model.addAttribute("widgets", (Object)this.widgetService.getWidgetsByCategory(categoryId, offset, this.getPageSize()));
        } else {
            model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgets(offset, this.getPageSize()));
        }
        model.addAttribute("offset", (Object)offset);
        model.addAttribute("selectedCategory", (Object)categoryId);
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/add"})
    public String viewAddWidgetForm(Model model, @RequestParam long referringPageId) {
        Widget widget = new Widget();
        model.addAttribute("referringPageId", (Object)referringPageId);
        model.addAttribute("widget", (Object)widget);
        return "templates.user.addwidget";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"widget/add"})
    public String viewAddWidgetResult(@ModelAttribute Widget widget, BindingResult results, Model model, @RequestParam long referringPageId) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetValidator.validate(widget, (Errors)results);
        if (results.hasErrors()) {
            model.addAttribute("widget", (Object)widget);
            model.addAttribute("referringPageId", (Object)referringPageId);
            return "templates.user.addwidget";
        }
        widget.setWidgetStatus(WidgetStatus.PREVIEW);
        widget.setOwner(user);
        Widget storedWidget = this.widgetService.registerNewWidget(widget);
        return "redirect:/app/store/widget/" + storedWidget.getEntityId() + "?referringPageId=" + referringPageId;
    }

    private void widgetStoreModelHelper(Model model, long referringPageId, User user) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        model.addAttribute("widgetsStatistics", (Object)this.widgetService.getAllWidgetStatistics(user.getEntityId().longValue()));
        model.addAttribute("tags", (Object)this.tagService.getAllTags());
        model.addAttribute("categories", (Object)this.categoryService.getAll());
    }

    public int getPageSize() {
        PortalPreference pageSizePref = this.preferenceService.getPreference("pageSize");
        if (pageSizePref == null) {
            return 10;
        }
        try {
            return Integer.parseInt(pageSizePref.getValue());
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }
}

