/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import java.util.List;
import org.apache.rave.portal.model.Category;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"category", "tokencheck"})
public class CategoryController {
    private static final String SELECTED_ITEM = "category";
    @Autowired
    private UserService userService;
    @Autowired
    private CategoryService categoryService;

    @RequestMapping(value={"/admin/categories", "/admin/categories/"}, method={RequestMethod.GET})
    public String getCategories(@RequestParam(required=false) String action, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        List categories = this.categoryService.getAll();
        model.addAttribute("categories", (Object)categories);
        model.addAttribute(SELECTED_ITEM, (Object)new Category());
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        if (AdminControllerUtil.isCreateDeleteOrUpdate(action)) {
            model.addAttribute("actionresult", (Object)action);
        }
        return "templates.admin.categories";
    }

    @RequestMapping(value={"/admin/category/create"}, method={RequestMethod.POST})
    public String createCategory(@ModelAttribute Category category, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, Model model, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        User creator = this.userService.getAuthenticatedUser();
        boolean isValidRequest = this.validateRequest(category.getText(), creator);
        if (!isValidRequest) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
            return "templates.admin.categories";
        }
        this.categoryService.create(category.getText(), creator);
        status.setComplete();
        return "redirect:/app/admin/categories?action=create";
    }

    @RequestMapping(value={"/admin/category/update"}, method={RequestMethod.POST})
    public String updateCategory(@ModelAttribute(value="category") Category category, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, Model model, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        User currentUser = this.userService.getAuthenticatedUser();
        boolean isValidRequest = this.validateRequest(category, currentUser);
        if (!isValidRequest) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
            return "templates.admin.categoryDetail";
        }
        this.categoryService.update(category.getEntityId().longValue(), category.getText(), currentUser);
        status.setComplete();
        model.asMap().clear();
        return "redirect:/app/admin/categories?action=update";
    }

    @RequestMapping(value={"/admin/category/delete"}, method={RequestMethod.POST})
    public String deleteCategory(@ModelAttribute(value="category") Category category, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String confirmdelete, Model model, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        User creator = this.userService.getAuthenticatedUser();
        if (!Boolean.parseBoolean(confirmdelete)) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
            model.addAttribute("missingConfirm", (Object)true);
            return "templates.admin.categoryDetail";
        }
        boolean isValidRequest = this.validateRequest(category, creator);
        if (!isValidRequest) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
            return "templates.admin.categoryDetail";
        }
        this.categoryService.delete(category);
        status.setComplete();
        return "redirect:/app/admin/categories?action=delete";
    }

    @RequestMapping(value={"/admin/category/edit"}, method={RequestMethod.GET})
    public String editCategory(@RequestParam(required=true) long id, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        model.addAttribute(SELECTED_ITEM, (Object)this.categoryService.get(id));
        return "templates.admin.categoryDetail";
    }

    private boolean validateRequest(String text, User creator) {
        return text != null && creator != null && !text.equals("");
    }

    private boolean validateRequest(Category category, User modifier) {
        return this.validateRequest(category.getText(), modifier) && this.categoryService.get(category.getEntityId().longValue()) != null;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }
}

