/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import java.util.Map;
import java.util.Set;
import org.apache.rave.portal.model.PortalPreference;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.apache.rave.portal.web.model.PortalPreferenceForm;
import org.apache.rave.portal.web.validator.PortalPreferenceFormValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"preferenceForm", "tokencheck"})
public class PortalPreferenceController {
    private static final String SELECTED_ITEM = "preferences";
    @Autowired
    private PortalPreferenceService preferenceService;
    @Autowired
    private PortalPreferenceFormValidator formValidator;

    @RequestMapping(value={"/admin/preferences", "/admin/preferences/"}, method={RequestMethod.GET})
    public String viewPreferences(@RequestParam(required=false) String action, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        Map preferenceMap = this.preferenceService.getPreferencesAsMap();
        model.addAttribute("preferenceMap", (Object)preferenceMap);
        if (AdminControllerUtil.isDeleteOrUpdate(action)) {
            model.addAttribute("actionresult", (Object)action);
        }
        return "templates.admin.preferences";
    }

    @RequestMapping(value={"/admin/preferencedetail/edit"}, method={RequestMethod.GET})
    public String editPreferences(Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model);
        Map preferenceMap = this.preferenceService.getPreferencesAsMap();
        PortalPreferenceForm form = new PortalPreferenceForm(preferenceMap);
        model.addAttribute("preferenceForm", (Object)form);
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        return "templates.admin.preferencedetail";
    }

    @RequestMapping(value={"/admin/preferencedetail/update"}, method={RequestMethod.POST})
    public String updatePreferences(@ModelAttribute(value="preferenceForm") PortalPreferenceForm form, BindingResult result, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, ModelMap modelMap, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        this.formValidator.validate(form, (Errors)result);
        if (result.hasErrors()) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, (Model)modelMap);
            return "templates.admin.preferencedetail";
        }
        Set<Map.Entry<String, PortalPreference>> entries = form.getPreferenceMap().entrySet();
        for (Map.Entry<String, PortalPreference> entry : entries) {
            this.preferenceService.savePreference(entry.getValue());
        }
        modelMap.clear();
        status.setComplete();
        return "redirect:/app/admin/preferences?action=update";
    }

    void setFormValidator(PortalPreferenceFormValidator formValidator) {
        this.formValidator = formValidator;
    }

    public void setPreferenceService(PortalPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }
}

