/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.tag;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractContextAwareSingletonBeanDependentTag<T>
extends TagSupport {
    private static final String CONTEXT_KEY = "_RENDER_CONTEXT";
    protected Class<T> clazz;
    private T bean;

    protected AbstractContextAwareSingletonBeanDependentTag(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected void writeString(String output) throws JspException {
        try {
            this.pageContext.getOut().print(output);
        }
        catch (IOException e) {
            throw new JspException("Failed to render", (Throwable)e);
        }
    }

    protected T getBean() throws JspException {
        if (this.bean == null) {
            this.bean = this.getBeanFromContext();
        }
        return this.bean;
    }

    protected RenderContext getContext() {
        RenderContext context = (RenderContext)this.pageContext.getRequest().getAttribute(CONTEXT_KEY);
        if (context == null) {
            context = new RenderContext();
            context.setProperties(new HashMap());
            this.pageContext.getRequest().setAttribute(CONTEXT_KEY, (Object)context);
        }
        return context;
    }

    private T getBeanFromContext() throws JspException {
        return this.getBeanFromContext(this.clazz);
    }

    protected <E> E getBeanFromContext(Class<E> clazz) throws JspException {
        ServletContext currentServletContext = this.pageContext.getServletContext();
        WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)currentServletContext);
        return (E)springContext.getBean(clazz);
    }
}

