/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.tag;

import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.RenderService;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.tag.AbstractContextAwareSingletonBeanDependentTag;

public class RegionWidgetTag
extends AbstractContextAwareSingletonBeanDependentTag<RenderService> {
    private RegionWidget regionWidget;
    private static final String DISABLED_SCRIPT_BLOCK = "<script>rave.registerWidget(widgetsByRegionIdMap, %1$s, {type: 'DISABLED', regionWidgetId: %2$s, disabledMessage: '%3$s', collapsed: %4$s, widgetId: %5$s});</script>";

    public RegionWidgetTag() {
        super(RenderService.class);
    }

    public RegionWidget getRegionWidget() {
        return this.regionWidget;
    }

    public void setRegionWidget(RegionWidget regionWidget) {
        this.regionWidget = regionWidget;
    }

    public int doStartTag() throws JspException {
        if (this.regionWidget != null && ((RenderService)this.getBean()).getSupportedWidgetTypes().contains(this.regionWidget.getWidget().getType())) {
            if (this.regionWidget.getWidget().isDisableRendering()) {
                ScriptManager scriptManager = this.getBeanFromContext(ScriptManager.class);
                String widgetScript = String.format(DISABLED_SCRIPT_BLOCK, this.regionWidget.getRegion().getEntityId(), this.regionWidget.getEntityId(), StringEscapeUtils.escapeJavaScript((String)this.regionWidget.getWidget().getDisableRenderingMessage()), this.regionWidget.isCollapsed(), this.regionWidget.getWidget().getEntityId());
                scriptManager.registerScriptBlock(widgetScript, ScriptLocation.AFTER_RAVE, RenderScope.CURRENT_REQUEST, this.getContext());
            } else {
                this.writeString(((RenderService)this.getBean()).render(this.regionWidget, this.getContext()));
            }
        } else {
            throw new JspException("Unsupported regionWidget type or regionWidget not set: " + this.regionWidget);
        }
        this.regionWidget = null;
        return 1;
    }
}

