/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.UrlValidator;
import org.apache.rave.portal.model.Widget;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public abstract class WidgetValidator
implements Validator {
    protected static final String FIELD_URL = "url";
    private final UrlValidator urlValidator;

    public WidgetValidator() {
        String[] allowedSchemes = new String[]{"http", "https"};
        this.urlValidator = new UrlValidator(allowedSchemes);
    }

    public final boolean supports(Class<?> clazz) {
        return Widget.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Widget widget = (Widget)target;
        this.validateRequiredFields(errors);
        this.validateIfWidgetAlreadyExists(widget, errors);
        this.validateUrlFields(widget, errors);
    }

    protected abstract void validateIfWidgetAlreadyExists(Widget var1, Errors var2);

    private void validateRequiredFields(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"widget.title.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)FIELD_URL, (String)"widget.url.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"type", (String)"widget.type.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"description", (String)"widget.description.required");
    }

    private void validateUrlFields(Widget widget, Errors errors) {
        String titleUrl;
        String thumbnailUrl;
        String screenshotUrl;
        String url = widget.getUrl();
        if (StringUtils.isNotBlank((String)url) && !this.urlValidator.isValid(url)) {
            errors.rejectValue(FIELD_URL, "widget.url.malformed");
        }
        if (StringUtils.isNotBlank((String)(screenshotUrl = widget.getScreenshotUrl())) && !this.urlValidator.isValid(screenshotUrl)) {
            errors.rejectValue("screenshotUrl", "widget.screenshotUrl.malformed");
        }
        if (StringUtils.isNotBlank((String)(thumbnailUrl = widget.getThumbnailUrl())) && !this.urlValidator.isValid(thumbnailUrl)) {
            errors.rejectValue("thumbnailUrl", "widget.thumbnailUrl.malformed");
        }
        if (StringUtils.isNotBlank((String)(titleUrl = widget.getTitleUrl())) && !this.urlValidator.isValid(titleUrl)) {
            errors.rejectValue("titleUrl", "widget.titleUrl.malformed");
        }
    }
}

