/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc;

import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.Region;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.web.api.rpc.model.RpcOperation;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="rpcPageApi")
@RequestMapping(value={"/api/rpc/page/*"})
public class PageApi {
    private final PageService pageService;

    @Autowired
    public PageApi(PageService pageService) {
        this.pageService = pageService;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{pageId}/widget/add"})
    public RpcResult<RegionWidget> addWidgetToPage(final @PathVariable long pageId, final @RequestParam long widgetId) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.addWidgetToPage(pageId, widgetId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"regionWidget/{regionWidgetId}/move"})
    public RpcResult<RegionWidget> moveWidgetOnPage(final @PathVariable long regionWidgetId, final @RequestParam int newPosition, final @RequestParam long toRegion, final @RequestParam long fromRegion) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.moveRegionWidget(regionWidgetId, newPosition, toRegion, fromRegion);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"regionWidget/{regionWidgetId}/delete"})
    public RpcResult<Region> removeWidgetFromPage(final @PathVariable long regionWidgetId) {
        return new RpcOperation<Region>(){

            @Override
            public Region execute() {
                return PageApi.this.pageService.removeWidgetFromPage(regionWidgetId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"add"})
    public RpcResult<Page> addPage(final @RequestParam String pageName, final @RequestParam String pageLayoutCode) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.addNewUserPage(pageName, pageLayoutCode);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"get"})
    public RpcResult<Page> getPage(final @RequestParam long pageId) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.getPage(pageId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/update"}, method={RequestMethod.POST})
    public RpcResult<Page> updatePageProperties(final @PathVariable long pageId, final @RequestParam String name, final @RequestParam String layout) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.updatePage(pageId, name, layout);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{pageId}/move"})
    public RpcResult<Page> movePage(final @PathVariable long pageId, final @RequestParam(required=false) Long moveAfterPageId) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                Page page = null;
                page = moveAfterPageId == null ? PageApi.this.pageService.movePageToDefault(pageId) : PageApi.this.pageService.movePage(pageId, moveAfterPageId.longValue());
                return page;
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{toPageId}/moveWidget"})
    public RpcResult<RegionWidget> moveWidgetToPage(final @PathVariable long toPageId, final @RequestParam(required=false) long regionWidgetId) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.moveRegionWidgetToPage(regionWidgetId, toPageId);
            }
        }.getResult();
    }
}

