/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.PageLayout;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.PageLayoutService;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.util.ControllerUtils;
import org.apache.rave.portal.web.util.ViewNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PageController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;
    private UserService userService;
    private PageLayoutService pageLayoutService;

    @Autowired
    public PageController(PageService pageService, UserService userService, PageLayoutService pageLayoutService) {
        this.pageService = pageService;
        this.userService = userService;
        this.pageLayoutService = pageLayoutService;
    }

    @RequestMapping(value={"/page/view", "/index.html"}, method={RequestMethod.GET})
    public String viewDefault(Model model, HttpServletRequest request) {
        List<Page> pages = this.getAllPagesForAuthenticatedUser();
        Page page = this.pageService.getDefaultPageFromList(pages);
        List pageLayouts = this.pageLayoutService.getAllUserSelectable();
        this.addAttributesToModel(model, page, pages, pageLayouts);
        return ControllerUtils.getDeviceAppropriateView(request, ViewNames.getPageView(page.getPageLayout().getCode()), "templates.user.mobile_home");
    }

    @RequestMapping(value={"/page/view/{pageId}"}, method={RequestMethod.GET})
    public String view(@PathVariable Long pageId, Model model, HttpServletRequest request) {
        User user = this.userService.getAuthenticatedUser();
        this.logger.debug("attempting to get pageId {} for {}", (Object)pageId, (Object)user);
        List<Page> pages = this.getAllPagesForAuthenticatedUser();
        Page page = this.pageService.getPageFromList(pageId.longValue(), pages);
        List pageLayouts = this.pageLayoutService.getAllUserSelectable();
        this.addAttributesToModel(model, page, pages, pageLayouts);
        return ControllerUtils.getDeviceAppropriateView(request, ViewNames.getPageView(page.getPageLayout().getCode()), "templates.user.mobile_home");
    }

    private List<Page> getAllPagesForAuthenticatedUser() {
        User user = this.userService.getAuthenticatedUser();
        long userId = user.getEntityId();
        List pages = this.pageService.getAllUserPages(userId);
        if (pages.isEmpty()) {
            this.logger.info("User {} does not have any pages - creating default page", (Object)user.getUsername());
            this.pageService.addNewDefaultUserPage(userId);
            pages = this.pageService.getAllUserPages(userId);
        }
        return pages;
    }

    private void addAttributesToModel(Model model, Page page, List<Page> pages, List<PageLayout> pageLayouts) {
        model.addAttribute("page", (Object)page);
        model.addAttribute("pages", pages);
        model.addAttribute("pageLayouts", pageLayouts);
    }
}

