/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.util.ViewNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/person/*", "/person"})
public class ProfileController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UserService userService;
    private final PageService pageService;

    @Autowired
    public ProfileController(UserService userService, PageService pageService) {
        this.userService = userService;
        this.pageService = pageService;
    }

    @RequestMapping(value={"/{username:.*}"}, method={RequestMethod.GET})
    public String viewProfile(@PathVariable String username, ModelMap model, @RequestParam(required=false) Long referringPageId) {
        this.logger.debug("Viewing person profile for: " + username);
        User user = this.userService.getUserByUsername(username);
        Page personProfilePage = this.pageService.getPersonProfilePage(user.getEntityId().longValue());
        this.addAttributesToModel(model, user, referringPageId);
        model.addAttribute("page", (Object)personProfilePage);
        return ViewNames.getPersonPageView(personProfilePage.getPageLayout().getCode());
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateProfile(ModelMap model, @RequestParam(required=false) Long referringPageId, @ModelAttribute(value="updatedUser") User updatedUser) {
        this.logger.info("Updating " + updatedUser.getUsername() + " profile information");
        User user = this.userService.getAuthenticatedUser();
        user.setGivenName(updatedUser.getGivenName());
        user.setFamilyName(updatedUser.getFamilyName());
        user.setDisplayName(updatedUser.getDisplayName());
        user.setAboutMe(updatedUser.getAboutMe());
        user.setStatus(updatedUser.getStatus());
        user.setEmail(updatedUser.getEmail());
        this.userService.updateUserProfile(user);
        this.addAttributesToModel(model, user, referringPageId);
        return "redirect:/app/person/" + user.getUsername();
    }

    private void addAttributesToModel(ModelMap model, User user, Long referringPageId) {
        model.addAttribute("userProfile", (Object)user);
        model.addAttribute("referringPageId", (Object)referringPageId);
    }
}

