/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.rave.portal.model.NewUser;
import org.apache.rave.portal.service.CaptchaService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.validator.NewPasswordValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ReminderController {
    private static Logger log = LoggerFactory.getLogger(ReminderController.class);
    private final UserService userService;
    private final NewPasswordValidator passwordValidator;
    private final CaptchaService captchaService;

    @Autowired
    protected ReminderController(UserService userService, NewPasswordValidator passwordValidator, CaptchaService captchaService) {
        this.userService = userService;
        this.passwordValidator = passwordValidator;
        this.captchaService = captchaService;
    }

    @RequestMapping(value={"/retrieveusername", "/newpassword"})
    public void initialize(ModelMap model, HttpServletRequest request) {
        model.addAttribute("captchaHtml", (Object)this.captchaService.createHtml(request));
        model.addAttribute("newUser", (Object)new NewUser());
    }

    @RequestMapping(value={"/retrieveusername"}, method={RequestMethod.POST})
    public String requestUsername(@ModelAttribute NewUser newUser, BindingResult results, Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        log.debug("Requesting username reminder");
        if (!this.validateEmail(newUser, results, model, request)) {
            return this.captchaRequest(model, request, "templates.user.retrieveusername");
        }
        try {
            this.userService.sendUserNameReminder(newUser);
            this.populateRedirect(newUser, redirectAttributes);
            return "redirect:/app/retrieveusername";
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Exception while sending username reminder  {}", (Throwable)e);
            }
            results.reject("Unable to send username reminder :" + e.getMessage(), "Unable to send username reminder.");
            return this.captchaRequest(model, request, "templates.user.retrieveusername");
        }
    }

    @RequestMapping(value={"/newpassword"}, method={RequestMethod.POST})
    public String requestPassword(@ModelAttribute NewUser newUser, BindingResult results, Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        log.debug("Requesting password reminder");
        if (!this.validateEmail(newUser, results, model, request)) {
            return this.captchaRequest(model, request, "templates.user.newpassword");
        }
        try {
            this.userService.sendPasswordReminder(newUser);
            this.populateRedirect(newUser, redirectAttributes);
            return "redirect:/app/newpassword";
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Exception while sending password reminder  {}", (Throwable)e);
            }
            results.reject("Unable to send password reminder :" + e.getMessage(), "Unable to send password reminder.");
            return this.captchaRequest(model, request, "templates.user.newpassword");
        }
    }

    private boolean validateEmail(NewUser newUser, BindingResult results, Model model, HttpServletRequest request) {
        model.addAttribute("newUser", (Object)newUser);
        this.passwordValidator.validate(newUser, (Errors)results);
        if (results.hasErrors()) {
            log.info("newpassword request contains validation errors");
            return false;
        }
        String email = newUser.getEmail();
        log.debug("Submitted email {} is valid", (Object)email);
        if (!this.captchaService.isValid(request)) {
            log.debug("Captcha was invalid for user with email {}", (Object)email);
            return false;
        }
        return true;
    }

    private void populateRedirect(NewUser newUser, RedirectAttributes redirectAttributes) {
        redirectAttributes.addFlashAttribute("success", (Object)true);
        redirectAttributes.addFlashAttribute("email", (Object)newUser.getEmail());
    }

    private String captchaRequest(Model model, HttpServletRequest request, String view) {
        model.addAttribute("captchaHtml", (Object)this.captchaService.createHtml(request));
        return view;
    }
}

