/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.samoa.instances.Attribute;
import org.apache.samoa.instances.DenseInstance;
import org.apache.samoa.instances.Instance;
import org.apache.samoa.instances.InstanceInformation;
import org.apache.samoa.instances.Loader;
import org.apache.samoa.instances.SparseInstance;

public class ArffLoader
implements Loader {
    protected InstanceInformation instanceInformation;
    protected transient StreamTokenizer streamTokenizer;
    protected Reader reader;
    protected int size;
    protected int classAttribute;
    protected List<Attribute> attributes;

    public ArffLoader() {
    }

    public ArffLoader(Reader reader, int size, int classAttribute) {
        this.reader = reader;
        this.size = size;
        this.classAttribute = classAttribute;
        this.initStreamTokenizer(reader);
    }

    @Override
    public InstanceInformation getStructure() {
        return this.instanceInformation;
    }

    public Instance readInstance(Reader reader) {
        if (this.streamTokenizer == null) {
            this.initStreamTokenizer(reader);
        }
        while (this.streamTokenizer.ttype == 10) {
            try {
                this.streamTokenizer.nextToken();
            }
            catch (IOException ex) {
                Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.streamTokenizer.ttype == 123) {
            return this.readInstanceSparse();
        }
        return this.readInstanceDense();
    }

    public Instance readInstanceDense() {
        DenseInstance instance = new DenseInstance((double)(this.instanceInformation.numAttributes() + 1));
        int numAttribute = 0;
        try {
            while (numAttribute == 0 && this.streamTokenizer.ttype != -1) {
                while (this.streamTokenizer.ttype != 10 && this.streamTokenizer.ttype != -1) {
                    if (this.streamTokenizer.ttype == -2) {
                        this.setValue(instance, numAttribute, this.streamTokenizer.nval, true);
                    } else if (this.streamTokenizer.sval != null && (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34 || this.streamTokenizer.ttype == 39)) {
                        boolean isNumeric = this.attributes.get(numAttribute).isNumeric();
                        double value = "?".equals(this.streamTokenizer.sval) ? Double.NaN : (isNumeric ? Double.valueOf(this.streamTokenizer.sval) : (double)this.instanceInformation.attribute(numAttribute).indexOfValue(this.streamTokenizer.sval));
                        this.setValue(instance, numAttribute, value, isNumeric);
                    }
                    ++numAttribute;
                    this.streamTokenizer.nextToken();
                }
                this.streamTokenizer.nextToken();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return numAttribute > 0 ? instance : null;
    }

    private void setValue(Instance instance, int numAttribute, double value, boolean isNumber) {
        double valueAttribute = this.instanceInformation.attribute((int)numAttribute).isNominal ? value : value;
        if (this.instanceInformation.classIndex() == numAttribute) {
            instance.setClassValue(valueAttribute);
        } else {
            instance.setValue(numAttribute, valueAttribute);
        }
    }

    private Instance readInstanceSparse() {
        SparseInstance instance = new SparseInstance(1.0, null);
        ArrayList<Double> attributeValues = new ArrayList<Double>();
        ArrayList<Integer> indexValues = new ArrayList<Integer>();
        try {
            this.streamTokenizer.nextToken();
            while (this.streamTokenizer.ttype != 10 && this.streamTokenizer.ttype != -1) {
                while (this.streamTokenizer.ttype != 125) {
                    int numAttribute = this.streamTokenizer.ttype == -2 ? (int)this.streamTokenizer.nval : Integer.parseInt(this.streamTokenizer.sval);
                    this.streamTokenizer.nextToken();
                    if (this.streamTokenizer.ttype == -2) {
                        this.setSparseValue(instance, indexValues, attributeValues, numAttribute, this.streamTokenizer.nval, true);
                    } else if (this.streamTokenizer.sval != null && (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34)) {
                        if (this.attributes.get(numAttribute).isNumeric()) {
                            this.setSparseValue(instance, indexValues, attributeValues, numAttribute, Double.valueOf(this.streamTokenizer.sval), true);
                        } else {
                            this.setSparseValue(instance, indexValues, attributeValues, numAttribute, this.instanceInformation.attribute(numAttribute).indexOfValue(this.streamTokenizer.sval), false);
                        }
                    }
                    this.streamTokenizer.nextToken();
                }
                this.streamTokenizer.nextToken();
            }
            this.streamTokenizer.nextToken();
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        int[] arrayIndexValues = new int[attributeValues.size()];
        double[] arrayAttributeValues = new double[attributeValues.size()];
        for (int i = 0; i < arrayIndexValues.length; ++i) {
            arrayIndexValues[i] = (Integer)indexValues.get(i);
            arrayAttributeValues[i] = (Double)attributeValues.get(i);
        }
        instance.addSparseValues(arrayIndexValues, arrayAttributeValues, this.instanceInformation.numAttributes());
        return instance;
    }

    private void setSparseValue(Instance instance, List<Integer> indexValues, List<Double> attributeValues, int numAttribute, double value, boolean isNumber) {
        double valueAttribute = isNumber && this.instanceInformation.attribute((int)numAttribute).isNominal ? (double)this.instanceInformation.attribute(numAttribute).indexOfValue(Double.toString(value)) : value;
        if (this.instanceInformation.classIndex() == numAttribute) {
            instance.setClassValue(valueAttribute);
        } else {
            indexValues.add(numAttribute);
            attributeValues.add(valueAttribute);
        }
    }

    private Instance readDenseInstanceSparse() {
        DenseInstance instance = new DenseInstance((double)(this.instanceInformation.numAttributes() + 1));
        try {
            this.streamTokenizer.nextToken();
            while (this.streamTokenizer.ttype != 10 && this.streamTokenizer.ttype != -1) {
                while (this.streamTokenizer.ttype != 125) {
                    int numAttribute = (int)this.streamTokenizer.nval;
                    this.streamTokenizer.nextToken();
                    if (this.streamTokenizer.ttype == -2) {
                        this.setValue(instance, numAttribute, this.streamTokenizer.nval, true);
                    } else if (this.streamTokenizer.sval != null && (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34)) {
                        if (this.attributes.get(numAttribute).isNumeric()) {
                            this.setValue(instance, numAttribute, Double.valueOf(this.streamTokenizer.sval), true);
                        } else {
                            this.setValue(instance, numAttribute, this.instanceInformation.attribute(numAttribute).indexOfValue(this.streamTokenizer.sval), false);
                        }
                    }
                    this.streamTokenizer.nextToken();
                }
                this.streamTokenizer.nextToken();
            }
            this.streamTokenizer.nextToken();
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return instance;
    }

    private InstanceInformation getHeader() {
        String relation = "file stream";
        this.attributes = new ArrayList<Attribute>();
        try {
            this.streamTokenizer.nextToken();
            while (this.streamTokenizer.ttype != -1) {
                if (this.streamTokenizer.ttype == -3 && this.streamTokenizer.sval.startsWith("@")) {
                    String token = this.streamTokenizer.sval.toUpperCase();
                    if (token.startsWith("@RELATION")) {
                        this.streamTokenizer.nextToken();
                        relation = this.streamTokenizer.sval;
                    } else if (token.startsWith("@ATTRIBUTE")) {
                        this.streamTokenizer.nextToken();
                        String name = this.streamTokenizer.sval;
                        if (name == null) {
                            name = Double.toString(this.streamTokenizer.nval);
                        }
                        this.streamTokenizer.nextToken();
                        String type = this.streamTokenizer.sval;
                        if (this.streamTokenizer.ttype == 123) {
                            this.parseDoubleBrackests(name);
                        } else if (this.streamTokenizer.ttype == 10) {
                            this.streamTokenizer.nextToken();
                            if (this.streamTokenizer.ttype == 123) {
                                this.parseDoubleBrackests(name);
                            }
                        } else {
                            this.attributes.add(new Attribute(name));
                        }
                    } else if (token.startsWith("@DATA")) {
                        this.streamTokenizer.nextToken();
                        break;
                    }
                }
                this.streamTokenizer.nextToken();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new InstanceInformation(relation, this.attributes);
    }

    private void parseDoubleBrackests(String name) throws IOException {
        this.streamTokenizer.nextToken();
        ArrayList<String> attributeLabels = new ArrayList<String>();
        while (this.streamTokenizer.ttype != 125) {
            if (this.streamTokenizer.sval != null) {
                attributeLabels.add(this.streamTokenizer.sval);
            } else {
                attributeLabels.add(Double.toString(this.streamTokenizer.nval));
            }
            this.streamTokenizer.nextToken();
        }
        this.attributes.add(new Attribute(name, attributeLabels));
    }

    private void initStreamTokenizer(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        this.streamTokenizer = new StreamTokenizer(br);
        this.streamTokenizer.resetSyntax();
        this.streamTokenizer.whitespaceChars(0, 32);
        this.streamTokenizer.wordChars(33, 255);
        this.streamTokenizer.whitespaceChars(44, 44);
        this.streamTokenizer.commentChar(37);
        this.streamTokenizer.quoteChar(34);
        this.streamTokenizer.quoteChar(39);
        this.streamTokenizer.ordinaryChar(123);
        this.streamTokenizer.ordinaryChar(125);
        this.streamTokenizer.eolIsSignificant(true);
        this.instanceInformation = this.getHeader();
        if (this.classAttribute < 0) {
            this.instanceInformation.setClassIndex(this.instanceInformation.numAttributes() - 1);
        } else if (this.classAttribute > 0) {
            this.instanceInformation.setClassIndex(this.classAttribute - 1);
        }
    }

    @Override
    public Instance readInstance() {
        return this.readInstance(this.reader);
    }
}

