/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samoa.instances.Utils;

public class Attribute
implements Serializable {
    public static final String ARFF_ATTRIBUTE = "@attribute";
    public static final String ARFF_ATTRIBUTE_NUMERIC = "NUMERIC";
    public static final String ARFF_ATTRIBUTE_NOMINAL = "NOMINAL";
    public static final String ARFF_ATTRIBUTE_DATE = "DATE";
    protected boolean isNominal;
    protected boolean isNumeric;
    protected boolean isDate;
    protected String name;
    protected List<String> attributeValues;
    protected int index;
    private Map<String, Integer> valuesStringAttribute;

    public List<String> getAttributeValues() {
        return this.attributeValues;
    }

    public Attribute(String string) {
        this.name = string;
        this.isNumeric = true;
    }

    public Attribute(String attributeName, List<String> attributeValues) {
        this.name = attributeName;
        this.attributeValues = attributeValues;
        this.isNominal = true;
    }

    public Attribute() {
        this("");
    }

    public boolean isNominal() {
        return this.isNominal;
    }

    public String name() {
        return this.name;
    }

    public String value(int value) {
        return this.attributeValues.get(value);
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public int numValues() {
        if (this.isNumeric()) {
            return 0;
        }
        return this.attributeValues.size();
    }

    public int index() {
        return this.index;
    }

    String formatDate(double value) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        return sdf.format(new Date((long)value));
    }

    boolean isDate() {
        return this.isDate;
    }

    public final int indexOfValue(String value) {
        Integer val;
        if (!this.isNominal()) {
            return -1;
        }
        if (this.valuesStringAttribute == null) {
            this.valuesStringAttribute = new HashMap<String, Integer>();
            int count = 0;
            for (String stringValue : this.attributeValues) {
                this.valuesStringAttribute.put(stringValue, count);
                ++count;
            }
        }
        if ((val = this.valuesStringAttribute.get(value)) == null) {
            return -1;
        }
        return val;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_ATTRIBUTE).append(" ").append(Utils.quote(this.name)).append(" ");
        if (this.isNominal) {
            text.append(ARFF_ATTRIBUTE_NOMINAL);
        } else if (this.isNumeric) {
            text.append(ARFF_ATTRIBUTE_NUMERIC);
        } else if (this.isDate) {
            text.append(ARFF_ATTRIBUTE_DATE);
        }
        return text.toString();
    }
}

