/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.samoa.instances.AvroLoader;
import org.apache.samoa.instances.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroBinaryLoader
extends AvroLoader {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AvroBinaryLoader.class);
    protected DataFileStream<GenericRecord> dataFileStream = null;

    public AvroBinaryLoader(InputStream inputStream, int classAttribute) {
        super(classAttribute);
        this.initializeSchema(inputStream);
    }

    @Override
    public void initializeSchema(InputStream inputStream) {
        try {
            this.datumReader = new GenericDatumReader();
            this.dataFileStream = new DataFileStream(inputStream, this.datumReader);
            this.schema = this.dataFileStream.getSchema();
            this.instanceInformation = this.getHeader();
            this.isSparseData = this.isSparseData();
            if (this.classAttribute < 0) {
                this.instanceInformation.setClassIndex(this.instanceInformation.numAttributes() - 1);
            } else if (this.classAttribute > 0) {
                this.instanceInformation.setClassIndex(this.classAttribute - 1);
            }
        }
        catch (IOException ioException) {
            logger.error("Exception while reading the schema from Avro File : {}", (Throwable)ioException);
            throw new RuntimeException("Exception while reading the schema from Avro File : " + ioException);
        }
    }

    @Override
    public Instance readInstance() {
        GenericRecord record = null;
        try {
            if (this.dataFileStream.hasNext()) {
                record = (GenericRecord)this.dataFileStream.next();
            }
        }
        catch (Exception ioException) {
            logger.error("Exception while reading the Instance from Avro File. : {}", (Throwable)ioException);
            throw new RuntimeException("Exception while reading the Instance from Avro File. : " + ioException);
        }
        if (record == null) {
            this.closeReader();
            return null;
        }
        if (this.isSparseData) {
            return this.readInstanceSparse(record);
        }
        return this.readInstanceDense(record);
    }

    private void closeReader() {
        if (this.dataFileStream != null) {
            try {
                this.dataFileStream.close();
            }
            catch (IOException ioException) {
                logger.error("Exception while reading the Instance from Avro File. : {}", (Throwable)ioException);
                throw new RuntimeException("Exception while reading the Instance from Avro File. : " + ioException);
            }
        }
    }
}

