/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.samoa.instances.AvroLoader;
import org.apache.samoa.instances.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroJsonLoader
extends AvroLoader {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AvroJsonLoader.class);
    protected Reader reader = null;

    public AvroJsonLoader(InputStream inputStream, int classAttribute) {
        super(classAttribute);
        this.initializeSchema(inputStream);
    }

    @Override
    public void initializeSchema(InputStream inputStream) {
        String schemaString = null;
        try {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            schemaString = ((BufferedReader)this.reader).readLine();
            this.schema = new Schema.Parser().parse(schemaString);
            this.datumReader = new GenericDatumReader(this.schema);
            this.instanceInformation = this.getHeader();
            this.isSparseData = this.isSparseData();
            if (this.classAttribute < 0) {
                this.instanceInformation.setClassIndex(this.instanceInformation.numAttributes() - 1);
            } else if (this.classAttribute > 0) {
                this.instanceInformation.setClassIndex(this.classAttribute - 1);
            }
        }
        catch (IOException ioException) {
            logger.error("Exception while reading the schema from Avro File : {}", (Throwable)ioException);
            throw new RuntimeException("Exception while reading the schema from Avro File : " + ioException);
        }
    }

    @Override
    public Instance readInstance() {
        String line = null;
        JsonDecoder decoder = null;
        GenericRecord record = null;
        try {
            while ((line = ((BufferedReader)this.reader).readLine()) != null) {
                if (line == null || line.trim().length() <= 0) continue;
                decoder = DecoderFactory.get().jsonDecoder(this.schema, line);
                record = (GenericRecord)this.datumReader.read(null, (Decoder)decoder);
                break;
            }
        }
        catch (IOException ioException) {
            logger.error("Exception while reading the Instance from Avro File. : {}", (Throwable)ioException);
            throw new RuntimeException("Exception while reading the Instance from Avro File. : " + ioException);
        }
        if (record == null) {
            this.closeReader();
            return null;
        }
        if (this.isSparseData) {
            return this.readInstanceSparse(record);
        }
        return this.readInstanceDense(record);
    }

    private void closeReader() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ioException) {
                logger.error("Exception while reading the Instance from Avro File. : {}", (Throwable)ioException);
                throw new RuntimeException("Exception while reading the Instance from Avro File. : " + ioException);
            }
        }
    }
}

