/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.samoa.instances.Attribute;
import org.apache.samoa.instances.DenseInstance;
import org.apache.samoa.instances.Instance;
import org.apache.samoa.instances.InstanceInformation;
import org.apache.samoa.instances.Loader;
import org.apache.samoa.instances.SparseInstance;

public abstract class AvroLoader
implements Loader {
    private static final long serialVersionUID = 1L;
    protected Schema schema = null;
    protected InstanceInformation instanceInformation;
    protected List<Attribute> attributes;
    protected boolean isSparseData;
    protected int classAttribute;
    public DatumReader<GenericRecord> datumReader = null;
    protected static final String AVRO_LOADER_INVALID_TYPE_ERROR = "Invalid data type in the Avro data";
    protected static final String AVRO_LOADER_SCHEMA_READ_ERROR = "Exception while reading the schema from Avro File";
    protected static final String AVRO_LOADER_INSTANCE_READ_ERROR = "Exception while reading the Instance from Avro File.";

    public AvroLoader(int classAttribute) {
        this.classAttribute = classAttribute;
        this.isSparseData = false;
    }

    public abstract void initializeSchema(InputStream var1);

    @Override
    public abstract Instance readInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Instance readInstanceDense(GenericRecord record) {
        DenseInstance instance = new DenseInstance((double)(this.instanceInformation.numAttributes() + 1));
        int numAttribute = 0;
        for (Attribute attribute : this.attributes) {
            Object value = record.get(attribute.name);
            boolean isNumeric = this.attributes.get(numAttribute).isNumeric();
            boolean isNominal = this.attributes.get(numAttribute).isNominal();
            if (isNumeric) {
                if (value instanceof Double) {
                    this.setDenseValue(instance, numAttribute, (Double)value);
                } else if (value instanceof Long) {
                    this.setDenseValue(instance, numAttribute, ((Long)value).longValue());
                } else {
                    if (!(value instanceof Integer)) throw new RuntimeException("Invalid data type in the Avro data for Numeric Type : " + attribute.name);
                    this.setDenseValue(instance, numAttribute, ((Integer)value).intValue());
                }
            } else if (isNominal) {
                if (!(value instanceof GenericData.EnumSymbol)) {
                    throw new RuntimeException("Invalid data type in the Avro data for Nominal Type : " + attribute.name);
                }
                GenericData.EnumSymbol enumSymbolalue = (GenericData.EnumSymbol)value;
                String stringValue = enumSymbolalue.toString();
                double valueAttribute = "?".equals(stringValue) || stringValue == null ? Double.NaN : (double)this.instanceInformation.attribute(numAttribute).indexOfValue(stringValue);
                this.setDenseValue(instance, numAttribute, valueAttribute);
            }
            ++numAttribute;
        }
        if (numAttribute <= 0) return null;
        DenseInstance denseInstance = instance;
        return denseInstance;
    }

    private void setDenseValue(Instance instance, int numAttribute, double valueAttribute) {
        if (this.instanceInformation.classIndex() == numAttribute) {
            instance.setClassValue(valueAttribute);
        } else {
            instance.setValue(numAttribute, valueAttribute);
        }
    }

    protected Instance readInstanceSparse(GenericRecord record) {
        SparseInstance instance = new SparseInstance(1.0, null);
        int numAttribute = -1;
        ArrayList<Double> attributeValues = new ArrayList<Double>();
        ArrayList<Integer> indexValues = new ArrayList<Integer>();
        for (Attribute attribute : this.attributes) {
            Object value = record.get(attribute.name);
            boolean isNumeric = this.attributes.get(++numAttribute).isNumeric();
            boolean isNominal = this.attributes.get(numAttribute).isNominal();
            if (value == null) continue;
            if (isNumeric) {
                if (value instanceof Double) {
                    Double v = (double)((Double)value);
                    if (Double.isNaN(v) || Double.isInfinite(v)) continue;
                    this.setSparseValue(instance, indexValues, attributeValues, numAttribute, (Double)value);
                    continue;
                }
                if (value instanceof Long) {
                    this.setSparseValue(instance, indexValues, attributeValues, numAttribute, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    this.setSparseValue(instance, indexValues, attributeValues, numAttribute, ((Integer)value).intValue());
                    continue;
                }
                throw new RuntimeException("Invalid data type in the Avro data : " + attribute.name);
            }
            if (!isNominal) continue;
            if (!(value instanceof GenericData.EnumSymbol)) {
                throw new RuntimeException("Invalid data type in the Avro data : " + attribute.name);
            }
            GenericData.EnumSymbol enumSymbolalue = (GenericData.EnumSymbol)value;
            String stringValue = enumSymbolalue.toString();
            double valueAttribute = "?".equals(stringValue) || stringValue == null ? Double.NaN : (double)this.instanceInformation.attribute(numAttribute).indexOfValue(stringValue);
            this.setSparseValue(instance, indexValues, attributeValues, numAttribute, valueAttribute);
        }
        int[] arrayIndexValues = new int[attributeValues.size()];
        double[] arrayAttributeValues = new double[attributeValues.size()];
        for (int i = 0; i < arrayIndexValues.length; ++i) {
            arrayIndexValues[i] = (Integer)indexValues.get(i);
            arrayAttributeValues[i] = (Double)attributeValues.get(i);
        }
        instance.addSparseValues(arrayIndexValues, arrayAttributeValues, this.instanceInformation.numAttributes());
        return instance;
    }

    private void setSparseValue(Instance instance, List<Integer> indexValues, List<Double> attributeValues, int numAttribute, double valueAttribute) {
        if (this.instanceInformation.classIndex() == numAttribute) {
            instance.setClassValue(valueAttribute);
        } else {
            indexValues.add(numAttribute);
            attributeValues.add(valueAttribute);
        }
    }

    protected InstanceInformation getHeader() {
        String relation = this.schema.getName();
        this.attributes = new ArrayList<Attribute>();
        List fields = this.schema.getFields();
        for (Schema.Field field : fields) {
            Schema attributeSchema = field.schema();
            if (attributeSchema.getType() == Schema.Type.ENUM) {
                List attributeLabels = attributeSchema.getEnumSymbols();
                this.attributes.add(new Attribute(field.name(), attributeLabels));
                continue;
            }
            if (!this.isNumeric(field)) continue;
            this.attributes.add(new Attribute(field.name()));
        }
        return new InstanceInformation(relation, this.attributes);
    }

    private boolean isNumeric(Schema.Field field) {
        if (field.schema().getType() == Schema.Type.DOUBLE || field.schema().getType() == Schema.Type.FLOAT || field.schema().getType() == Schema.Type.LONG || field.schema().getType() == Schema.Type.INT) {
            return true;
        }
        if (field.schema().getType() == Schema.Type.UNION) {
            for (Schema schema : field.schema().getTypes()) {
                if (schema.getType() != Schema.Type.DOUBLE && schema.getType() != Schema.Type.FLOAT && schema.getType() != Schema.Type.LONG && schema.getType() != Schema.Type.INT) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSparseData() {
        List fields = this.schema.getFields();
        for (Schema.Field field : fields) {
            Schema attributeSchema = field.schema();
            if (attributeSchema.getType() != Schema.Type.UNION) continue;
            List unionTypes = attributeSchema.getTypes();
            for (Schema unionSchema : unionTypes) {
                if (unionSchema.getType() != Schema.Type.NULL) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public InstanceInformation getStructure() {
        return this.instanceInformation;
    }
}

