/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.samoa.instances.ArffLoader;
import org.apache.samoa.instances.Attribute;
import org.apache.samoa.instances.AvroBinaryLoader;
import org.apache.samoa.instances.AvroJsonLoader;
import org.apache.samoa.instances.Instance;
import org.apache.samoa.instances.InstanceInformation;
import org.apache.samoa.instances.InstancesHeader;
import org.apache.samoa.instances.Loader;
import org.apache.samoa.instances.Utils;

public class Instances
implements Serializable {
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    protected InstanceInformation instanceInformation;
    protected List<Instance> instances;
    protected transient Loader loader;
    protected int classAttribute;

    public Instances(InstancesHeader modelContext) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Instances(Instances chunk) {
        this.instanceInformation = chunk.instanceInformation();
        this.instances = chunk.instances;
    }

    public Instances() {
    }

    public Instances(Reader reader, int size, int classAttribute) {
        this.classAttribute = classAttribute;
        this.loader = new ArffLoader(reader, 0, classAttribute);
        this.instanceInformation = this.loader.getStructure();
        this.instances = new ArrayList<Instance>();
    }

    public Instances(InputStream inputStream, int classAttribute, String encodingFormat) {
        this.classAttribute = classAttribute;
        this.loader = encodingFormat.equalsIgnoreCase(AVRO_ENCODING_FORMAT.BINARY.toString()) ? new AvroBinaryLoader(inputStream, classAttribute) : new AvroJsonLoader(inputStream, classAttribute);
        this.instanceInformation = this.loader.getStructure();
        this.instances = new ArrayList<Instance>();
    }

    public Instances(Instances chunk, int capacity) {
        this(chunk);
    }

    public Instances(String st, List<Attribute> v, int capacity) {
        this.instanceInformation = new InstanceInformation(st, v);
        this.instances = new ArrayList<Instance>();
    }

    public Instances(Instances chunk, int i, int j) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Instances(StringReader st, int v) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setRelationName(String string) {
        this.instanceInformation.setRelationName(string);
    }

    public String getRelationName() {
        return this.instanceInformation.getRelationName();
    }

    public int classIndex() {
        return this.instanceInformation.classIndex();
    }

    public void setClassIndex(int classIndex) {
        this.instanceInformation.setClassIndex(classIndex);
    }

    public Attribute classAttribute() {
        return this.instanceInformation.classAttribute();
    }

    public int numAttributes() {
        return this.instanceInformation.numAttributes();
    }

    public Attribute attribute(int w) {
        return this.instanceInformation.attribute(w);
    }

    public int numClasses() {
        return this.instanceInformation.numClasses();
    }

    public void deleteAttributeAt(Integer integer) {
        this.instanceInformation.deleteAttributeAt(integer);
    }

    public void insertAttributeAt(Attribute attribute, int i) {
        this.instanceInformation.insertAttributeAt(attribute, i);
    }

    public Instance instance(int num) {
        return this.instances.get(num);
    }

    public int numInstances() {
        return this.instances.size();
    }

    public void add(Instance inst) {
        this.instances.add(inst.copy());
    }

    public void randomize(Random random) {
        for (int j = this.numInstances() - 1; j > 0; --j) {
            this.swap(j, random.nextInt(j + 1));
        }
    }

    public void stratify(int numFolds) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Instances trainCV(int numFolds, int n, Random random) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Instances testCV(int numFolds, int n) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public double meanOrMode(int j) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean readInstance(Reader fileReader) {
        if (this.loader == null) {
            this.loader = new ArffLoader(fileReader, 0, this.classAttribute);
        }
        return this.readInstance();
    }

    public boolean readInstance() {
        Instance inst = this.loader.readInstance();
        if (inst != null) {
            inst.setDataset(this);
            this.add(inst);
            return true;
        }
        return false;
    }

    public void delete() {
        this.instances = new ArrayList<Instance>();
    }

    public void swap(int i, int j) {
        Instance in = this.instances.get(i);
        this.instances.set(i, this.instances.get(j));
        this.instances.set(j, in);
    }

    private InstanceInformation instanceInformation() {
        return this.instanceInformation;
    }

    public Attribute attribute(String name) {
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (!this.attribute(i).name().equals(name)) continue;
            return this.attribute(i);
        }
        return null;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i).toString());
            if (i >= this.numInstances() - 1) continue;
            text.append('\n');
        }
        return text.toString();
    }

    public String toStringArff() {
        StringBuilder text = new StringBuilder();
        text.append(ARFF_RELATION).append(" ").append(Utils.quote(this.getRelationName())).append("\n\n");
        for (int i = 0; i < this.numAttributes(); ++i) {
            text.append(this.attribute(i).toString()).append("\n");
        }
        text.append("\n").append(ARFF_DATA).append("\n");
        text.append(this.toString());
        return text.toString();
    }

    protected static enum AVRO_ENCODING_FORMAT {
        JSON,
        BINARY;

    }
}

