/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.instances;

import org.apache.samoa.instances.Attribute;
import org.apache.samoa.instances.DenseInstanceData;
import org.apache.samoa.instances.Instance;
import org.apache.samoa.instances.InstanceData;
import org.apache.samoa.instances.Instances;
import org.apache.samoa.instances.InstancesHeader;
import org.apache.samoa.instances.SingleClassInstanceData;
import org.apache.samoa.instances.SparseInstanceData;

public class SingleLabelInstance
implements Instance {
    protected double weight;
    protected InstanceData instanceData;
    protected InstanceData classData;
    protected InstancesHeader instanceInformation;

    public SingleLabelInstance() {
    }

    public SingleLabelInstance(SingleLabelInstance inst) {
        this.weight = inst.weight;
        this.instanceData = inst.instanceData;
        this.classData = inst.classData;
        this.instanceInformation = inst.instanceInformation;
    }

    public SingleLabelInstance(double weight, double[] res) {
        this.weight = weight;
        this.instanceData = new DenseInstanceData(res);
        this.classData = new SingleClassInstanceData();
    }

    public SingleLabelInstance(double weight, double[] attributeValues, int[] indexValues, int numberAttributes) {
        this.weight = weight;
        this.instanceData = new SparseInstanceData(attributeValues, indexValues, numberAttributes);
        this.classData = new SingleClassInstanceData();
    }

    public SingleLabelInstance(double weight, InstanceData instanceData) {
        this.weight = weight;
        this.instanceData = instanceData;
        this.classData = new SingleClassInstanceData();
    }

    public SingleLabelInstance(int numAttributes) {
        this.instanceData = new DenseInstanceData(new double[numAttributes]);
        this.weight = 1.0;
        this.classData = new SingleClassInstanceData();
        this.instanceInformation = new InstancesHeader();
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public Attribute attribute(int instAttIndex) {
        return this.instanceInformation.attribute(instAttIndex);
    }

    @Override
    public void deleteAttributeAt(int i) {
    }

    @Override
    public void insertAttributeAt(int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int numAttributes() {
        return this.instanceInformation.numAttributes();
    }

    @Override
    public double value(int instAttIndex) {
        return this.instanceData.value(instAttIndex);
    }

    @Override
    public boolean isMissing(int instAttIndex) {
        return this.instanceData.isMissing(instAttIndex);
    }

    @Override
    public int numValues() {
        return this.instanceData.numValues();
    }

    @Override
    public int index(int i) {
        return this.instanceData.index(i);
    }

    @Override
    public double valueSparse(int i) {
        return this.instanceData.valueSparse(i);
    }

    @Override
    public boolean isMissingSparse(int p) {
        return this.instanceData.isMissingSparse(p);
    }

    @Override
    public double value(Attribute attribute) {
        return this.value(attribute.index());
    }

    @Override
    public String stringValue(int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double[] toDoubleArray() {
        return this.instanceData.toDoubleArray();
    }

    @Override
    public void setValue(int numAttribute, double d) {
        this.instanceData.setValue(numAttribute, d);
    }

    @Override
    public double classValue() {
        return this.classData.value(0);
    }

    @Override
    public int classIndex() {
        return this.instanceInformation.classIndex();
    }

    @Override
    public int numClasses() {
        return this.instanceInformation.numClasses();
    }

    @Override
    public boolean classIsMissing() {
        return this.classData.isMissing(0);
    }

    @Override
    public Attribute classAttribute() {
        return this.instanceInformation.attribute(0);
    }

    @Override
    public void setClassValue(double d) {
        this.classData.setValue(0, d);
    }

    @Override
    public Instance copy() {
        SingleLabelInstance inst = new SingleLabelInstance(this);
        return inst;
    }

    @Override
    public Instances dataset() {
        return this.instanceInformation;
    }

    @Override
    public void setDataset(Instances dataset) {
        this.instanceInformation = new InstancesHeader(dataset);
    }

    @Override
    public void addSparseValues(int[] indexValues, double[] attributeValues, int numberAttributes) {
        this.instanceData = new SparseInstanceData(attributeValues, indexValues, numberAttributes);
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numValues(); ++i) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.value(i));
        }
        text.append(",").append(this.weight());
        return text.toString();
    }
}

