/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa;

import com.github.javacliparser.ClassOption;
import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.Option;
import org.apache.samoa.tasks.Task;
import org.apache.samoa.topology.ComponentFactory;
import org.apache.samoa.topology.impl.SimpleComponentFactory;
import org.apache.samoa.topology.impl.SimpleEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDoTask {
    private static final String SUPPRESS_STATUS_OUT_MSG = "Suppress the task status output. Normally it is sent to stderr.";
    private static final String SUPPRESS_RESULT_OUT_MSG = "Suppress the task result output. Normally it is sent to stdout.";
    private static final String STATUS_UPDATE_FREQ_MSG = "Wait time in milliseconds between status updates.";
    private static final Logger logger = LoggerFactory.getLogger(LocalDoTask.class);

    public static void main(String[] args) {
        Task task;
        FlagOption suppressStatusOutOpt = new FlagOption("suppressStatusOut", 'S', SUPPRESS_STATUS_OUT_MSG);
        FlagOption suppressResultOutOpt = new FlagOption("suppressResultOut", 'R', SUPPRESS_RESULT_OUT_MSG);
        IntOption statusUpdateFreqOpt = new IntOption("statusUpdateFrequency", 'F', STATUS_UPDATE_FREQ_MSG, 1000, 0, Integer.MAX_VALUE);
        Option[] extraOptions = new Option[]{suppressStatusOutOpt, suppressResultOutOpt, statusUpdateFreqOpt};
        StringBuilder cliString = new StringBuilder();
        for (String arg : args) {
            cliString.append(" ").append(arg);
        }
        logger.debug("Command line string = {}", (Object)cliString.toString());
        System.out.println("Command line string = " + cliString.toString());
        try {
            task = (Task)ClassOption.cliStringToObject((String)cliString.toString(), Task.class, (Option[])extraOptions);
            logger.info("Successfully instantiating {}", (Object)task.getClass().getCanonicalName());
        }
        catch (Exception e) {
            logger.error("Fail to initialize the task", (Throwable)e);
            System.out.println("Fail to initialize the task" + e);
            return;
        }
        task.setFactory((ComponentFactory)new SimpleComponentFactory());
        task.init();
        SimpleEngine.submitTopology(task.getTopology());
    }
}

