/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.topology.impl;

import org.apache.samoa.core.ContentEvent;
import org.apache.samoa.core.Processor;
import org.apache.samoa.topology.AbstractProcessingItem;
import org.apache.samoa.topology.IProcessingItem;
import org.apache.samoa.topology.ProcessingItem;
import org.apache.samoa.topology.Stream;
import org.apache.samoa.topology.impl.SimpleStream;
import org.apache.samoa.utils.PartitioningScheme;
import org.apache.samoa.utils.StreamDestination;

class SimpleProcessingItem
extends AbstractProcessingItem {
    private IProcessingItem[] arrayProcessingItem;

    SimpleProcessingItem(Processor processor) {
        super(processor);
    }

    SimpleProcessingItem(Processor processor, int parallelism) {
        super(processor);
        this.setParallelism(parallelism);
    }

    public IProcessingItem getProcessingItem(int i) {
        return this.arrayProcessingItem[i];
    }

    protected ProcessingItem addInputStream(Stream inputStream, PartitioningScheme scheme) {
        StreamDestination destination = new StreamDestination((IProcessingItem)this, this.getParallelism(), scheme);
        ((SimpleStream)inputStream).addDestination(destination);
        return this;
    }

    public SimpleProcessingItem copy() {
        Processor processor = this.getProcessor();
        return new SimpleProcessingItem(processor.newProcessor(processor));
    }

    public void processEvent(ContentEvent event, int counter) {
        int parallelism = this.getParallelism();
        if (this.arrayProcessingItem == null && parallelism > 0) {
            this.arrayProcessingItem = new IProcessingItem[parallelism];
            for (int j = 0; j < parallelism; ++j) {
                this.arrayProcessingItem[j] = this.copy();
                this.arrayProcessingItem[j].getProcessor().onCreate(j);
            }
        }
        if (this.arrayProcessingItem != null) {
            IProcessingItem pi = this.getProcessingItem(counter);
            Processor p = pi.getProcessor();
            this.getProcessingItem(counter).getProcessor().process(event);
        }
    }
}

