/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samoa.topology.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.samoa.core.ContentEvent;
import org.apache.samoa.topology.AbstractStream;
import org.apache.samoa.topology.IProcessingItem;
import org.apache.samoa.topology.impl.SimpleProcessingItem;
import org.apache.samoa.utils.StreamDestination;

class SimpleStream
extends AbstractStream {
    private List<StreamDestination> destinations = new LinkedList<StreamDestination>();
    private int maxCounter = 1;
    private int eventCounter = 0;

    SimpleStream(IProcessingItem sourcePi) {
        super(sourcePi);
    }

    private int getNextCounter() {
        if (this.maxCounter > 0 && this.eventCounter >= this.maxCounter) {
            this.eventCounter = 0;
        }
        ++this.eventCounter;
        return this.eventCounter;
    }

    public void put(ContentEvent event) {
        this.put(event, this.getNextCounter());
    }

    private void put(ContentEvent event, int counter) {
        for (StreamDestination destination : this.destinations) {
            SimpleProcessingItem pi = (SimpleProcessingItem)destination.getProcessingItem();
            int parallelism = destination.getParallelism();
            switch (destination.getPartitioningScheme()) {
                case SHUFFLE: {
                    pi.processEvent(event, counter % parallelism);
                    break;
                }
                case GROUP_BY_KEY: {
                    HashCodeBuilder hb = new HashCodeBuilder();
                    hb.append((Object)event.getKey());
                    int key = hb.build() % parallelism;
                    pi.processEvent(event, key);
                    break;
                }
                case BROADCAST: {
                    for (int p = 0; p < parallelism; ++p) {
                        pi.processEvent(event, p);
                    }
                    break;
                }
            }
        }
    }

    public void addDestination(StreamDestination destination) {
        this.destinations.add(destination);
        if (this.maxCounter <= 0) {
            this.maxCounter = 1;
        }
        this.maxCounter *= destination.getParallelism();
    }
}

