/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ClassLoaderUtils;
import org.w3c.dom.Element;

public abstract class DOMKeyValue<K extends PublicKey>
extends BaseStructure
implements KeyValue {
    private static final String XMLDSIG_11_XMLNS = "http://www.w3.org/2009/xmldsig11#";
    private final K publicKey;

    public DOMKeyValue(K key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.publicKey = key;
    }

    public DOMKeyValue(Element kvtElem) throws MarshalException {
        this.publicKey = this.unmarshalKeyValue(kvtElem);
    }

    static KeyValue unmarshal(Element kvElem) throws MarshalException {
        Element kvtElem = DOMUtils.getFirstChildElement(kvElem);
        if (kvtElem.getLocalName().equals("DSAKeyValue")) {
            return new DSA(kvtElem);
        }
        if (kvtElem.getLocalName().equals("RSAKeyValue")) {
            return new RSA(kvtElem);
        }
        if (kvtElem.getLocalName().equals("ECKeyValue")) {
            return new EC(kvtElem);
        }
        return new Unknown(kvtElem);
    }

    @Override
    public PublicKey getPublicKey() throws KeyException {
        if (this.publicKey == null) {
            throw new KeyException("can't convert KeyValue to PublicKey");
        }
        return this.publicKey;
    }

    public void marshal(XmlWriter xwriter, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "KeyValue", "http://www.w3.org/2000/09/xmldsig#");
        this.marshalPublicKey(xwriter, this.publicKey, dsPrefix, context);
        xwriter.writeEndElement();
    }

    abstract void marshalPublicKey(XmlWriter var1, K var2, String var3, XMLCryptoContext var4) throws MarshalException;

    abstract K unmarshalKeyValue(Element var1) throws MarshalException;

    private static PublicKey generatePublicKey(KeyFactory kf, KeySpec keyspec) {
        try {
            return kf.generatePublic(keyspec);
        }
        catch (InvalidKeySpecException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        try {
            KeyValue kv = (KeyValue)obj;
            if (this.publicKey == null ? kv.getPublicKey() != null : !this.publicKey.equals(kv.getPublicKey())) {
                return false;
            }
        }
        catch (KeyException ke) {
            return false;
        }
        return true;
    }

    public static BigInteger decode(Element elem) throws MarshalException {
        try {
            String base64str = BaseStructure.textOfNode(elem);
            return Base64.decodeBigIntegerFromString(base64str);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    public static void writeBase64BigIntegerElement(XmlWriter xwriter, String prefix, String localName, String namespaceURI, BigInteger value) {
        xwriter.writeTextElement(prefix, localName, namespaceURI, Base64.encode(value));
    }

    public static void marshal(XmlWriter xwriter, BigInteger bigNum) {
        xwriter.writeCharacters(Base64.encode(bigNum));
    }

    public int hashCode() {
        int result = 17;
        if (this.publicKey != null) {
            result = 31 * result + this.publicKey.hashCode();
        }
        return result;
    }

    static final class Unknown
    extends DOMKeyValue<PublicKey> {
        private XMLStructure externalPublicKey;

        Unknown(Element elem) throws MarshalException {
            super(elem);
        }

        @Override
        PublicKey unmarshalKeyValue(Element kvElem) throws MarshalException {
            this.externalPublicKey = new DOMStructure(kvElem);
            return null;
        }

        @Override
        void marshalPublicKey(XmlWriter xwriter, PublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            xwriter.marshalStructure(this.externalPublicKey, dsPrefix, context);
        }
    }

    static final class EC
    extends DOMKeyValue<ECPublicKey> {
        private byte[] ecPublicKey;
        private KeyFactory eckf;
        private ECParameterSpec ecParams;
        private Method encodePoint;
        private Method decodePoint;
        private Method getCurveName;
        private Method getECParameterSpec;

        EC(ECPublicKey ecKey) throws KeyException {
            super(ecKey);
            ECPoint ecPoint = ecKey.getW();
            this.ecParams = ecKey.getParams();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ClassNotFoundException, NoSuchMethodException {
                        EC.this.getMethods();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new KeyException("ECKeyValue not supported", pae.getException());
            }
            Object[] args = new Object[]{ecPoint, this.ecParams.getCurve()};
            try {
                this.ecPublicKey = (byte[])this.encodePoint.invoke(null, args);
            }
            catch (IllegalAccessException iae) {
                throw new KeyException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new KeyException(ite);
            }
        }

        EC(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        void getMethods() throws ClassNotFoundException, NoSuchMethodException {
            Class<?> c = ClassLoaderUtils.loadClass("sun.security.ec.ECParameters", DOMKeyValue.class);
            Class[] params = new Class[]{ECPoint.class, EllipticCurve.class};
            this.encodePoint = c.getMethod("encodePoint", params);
            params = new Class[]{ECParameterSpec.class};
            this.getCurveName = c.getMethod("getCurveName", params);
            params = new Class[]{byte[].class, EllipticCurve.class};
            this.decodePoint = c.getMethod("decodePoint", params);
            c = ClassLoaderUtils.loadClass("sun.security.ec.NamedCurve", DOMKeyValue.class);
            params = new Class[]{String.class};
            this.getECParameterSpec = c.getMethod("getECParameterSpec", params);
        }

        @Override
        void marshalPublicKey(XmlWriter xwriter, ECPublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            String prefix = DOMUtils.getNSPrefix(context, DOMKeyValue.XMLDSIG_11_XMLNS);
            xwriter.writeStartElement(prefix, "ECKeyValue", DOMKeyValue.XMLDSIG_11_XMLNS);
            xwriter.writeStartElement(prefix, "NamedCurve", DOMKeyValue.XMLDSIG_11_XMLNS);
            xwriter.writeNamespace(prefix, DOMKeyValue.XMLDSIG_11_XMLNS);
            Object[] args = new Object[]{this.ecParams};
            try {
                String oid = (String)this.getCurveName.invoke(null, args);
                xwriter.writeAttribute("", "", "URI", "urn:oid:" + oid);
            }
            catch (IllegalAccessException iae) {
                throw new MarshalException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new MarshalException(ite);
            }
            xwriter.writeEndElement();
            xwriter.writeStartElement(prefix, "PublicKey", DOMKeyValue.XMLDSIG_11_XMLNS);
            String encoded = Base64.encode(this.ecPublicKey);
            xwriter.writeCharacters(encoded);
            xwriter.writeEndElement();
            xwriter.writeEndElement();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        ECPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException {
            if (this.eckf == null) {
                try {
                    this.eckf = KeyFactory.getInstance("EC");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("unable to create EC KeyFactory: " + e.getMessage());
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ClassNotFoundException, NoSuchMethodException {
                        EC.this.getMethods();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new MarshalException("ECKeyValue not supported", pae.getException());
            }
            ECParameterSpec ecParams = null;
            Element curElem = DOMUtils.getFirstChildElement(kvtElem);
            if (curElem.getLocalName().equals("ECParameters")) {
                throw new UnsupportedOperationException("ECParameters not supported");
            }
            if (!curElem.getLocalName().equals("NamedCurve")) throw new MarshalException("Invalid ECKeyValue");
            String uri = DOMUtils.getAttributeValue(curElem, "URI");
            if (!uri.startsWith("urn:oid:")) throw new MarshalException("Invalid NamedCurve URI");
            String oid = uri.substring(8);
            try {
                Object[] args = new Object[]{oid};
                ecParams = (ECParameterSpec)this.getECParameterSpec.invoke(null, args);
            }
            catch (IllegalAccessException iae) {
                throw new MarshalException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new MarshalException(ite);
            }
            curElem = DOMUtils.getNextSiblingElement(curElem);
            ECPoint ecPoint = null;
            try {
                Object[] args = new Object[]{Base64.decode(curElem), ecParams.getCurve()};
                ecPoint = (ECPoint)this.decodePoint.invoke(null, args);
            }
            catch (Base64DecodingException bde) {
                throw new MarshalException("Invalid EC PublicKey", bde);
            }
            catch (IllegalAccessException iae) {
                throw new MarshalException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new MarshalException(ite);
            }
            ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, ecParams);
            return (ECPublicKey)DOMKeyValue.generatePublicKey(this.eckf, spec);
        }
    }

    static final class DSA
    extends DOMKeyValue<DSAPublicKey> {
        private KeyFactory dsakf;

        DSA(DSAPublicKey key) throws KeyException {
            super(key);
        }

        DSA(Element elem) throws MarshalException {
            super(elem);
        }

        @Override
        void marshalPublicKey(XmlWriter xwriter, DSAPublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DSAParams params = publicKey.getParams();
            xwriter.writeStartElement(dsPrefix, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
            DSA.writeBase64BigIntegerElement(xwriter, dsPrefix, "P", "http://www.w3.org/2000/09/xmldsig#", params.getP());
            DSA.writeBase64BigIntegerElement(xwriter, dsPrefix, "Q", "http://www.w3.org/2000/09/xmldsig#", params.getQ());
            DSA.writeBase64BigIntegerElement(xwriter, dsPrefix, "G", "http://www.w3.org/2000/09/xmldsig#", params.getG());
            DSA.writeBase64BigIntegerElement(xwriter, dsPrefix, "Y", "http://www.w3.org/2000/09/xmldsig#", publicKey.getY());
            xwriter.writeEndElement();
        }

        @Override
        DSAPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException {
            if (this.dsakf == null) {
                try {
                    this.dsakf = KeyFactory.getInstance("DSA");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("unable to create DSA KeyFactory: " + e.getMessage());
                }
            }
            Element curElem = DOMUtils.getFirstChildElement(kvtElem);
            BigInteger p = null;
            BigInteger q = null;
            if (curElem.getLocalName().equals("P")) {
                p = DSA.decode(curElem);
                curElem = DOMUtils.getNextSiblingElement(curElem);
                q = DSA.decode(curElem);
                curElem = DOMUtils.getNextSiblingElement(curElem);
            }
            BigInteger g = null;
            if (curElem.getLocalName().equals("G")) {
                g = DSA.decode(curElem);
                curElem = DOMUtils.getNextSiblingElement(curElem);
            }
            BigInteger y = DSA.decode(curElem);
            curElem = DOMUtils.getNextSiblingElement(curElem);
            DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
            return (DSAPublicKey)DOMKeyValue.generatePublicKey(this.dsakf, spec);
        }
    }

    static final class RSA
    extends DOMKeyValue<RSAPublicKey> {
        private KeyFactory rsakf;

        RSA(RSAPublicKey key) throws KeyException {
            super(key);
        }

        RSA(Element elem) throws MarshalException {
            super(elem);
        }

        @Override
        void marshalPublicKey(XmlWriter xwriter, RSAPublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            xwriter.writeStartElement(dsPrefix, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
            RSA.writeBase64BigIntegerElement(xwriter, dsPrefix, "Modulus", "http://www.w3.org/2000/09/xmldsig#", publicKey.getModulus());
            RSA.writeBase64BigIntegerElement(xwriter, dsPrefix, "Exponent", "http://www.w3.org/2000/09/xmldsig#", publicKey.getPublicExponent());
            xwriter.writeEndElement();
        }

        @Override
        RSAPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException {
            if (this.rsakf == null) {
                try {
                    this.rsakf = KeyFactory.getInstance("RSA");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("unable to create RSA KeyFactory: " + e.getMessage());
                }
            }
            Element modulusElem = DOMUtils.getFirstChildElement(kvtElem);
            BigInteger modulus = RSA.decode(modulusElem);
            Element exponentElem = DOMUtils.getNextSiblingElement(modulusElem);
            BigInteger exponent = RSA.decode(exponentElem);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            return (RSAPublicKey)DOMKeyValue.generatePublicKey(this.rsakf, spec);
        }
    }
}

