/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Namespace;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecEventFactory;
import org.apache.xml.security.stax.ext.stax.XMLSecNamespace;

public class XMLSecurityStreamWriter
implements XMLStreamWriter {
    private final OutputProcessorChain outputProcessorChain;
    private final Deque<QName> startElementStack = new ArrayDeque<QName>();
    private QName openStartElement = null;
    private final List<XMLSecAttribute> currentAttributes = new ArrayList<XMLSecAttribute>();
    private final Deque<Map<String, XMLSecNamespace>> nsStack;
    private NamespaceContext namespaceContext;
    private final NamespaceContext defaultNamespaceContext;
    private boolean haveToWriteEndElement = false;
    private boolean endDocumentWritten = false;

    public XMLSecurityStreamWriter(OutputProcessorChain outputProcessorChain) {
        this.outputProcessorChain = outputProcessorChain;
        this.nsStack = new ArrayDeque<Map<String, XMLSecNamespace>>();
        this.nsStack.push(Collections.emptyMap());
        this.defaultNamespaceContext = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                for (Map next : XMLSecurityStreamWriter.this.nsStack) {
                    Namespace ns = (Namespace)next.get(prefix);
                    if (ns == null) continue;
                    return ns.getNamespaceURI();
                }
                if (XMLSecurityStreamWriter.this.namespaceContext != null) {
                    return XMLSecurityStreamWriter.this.namespaceContext.getNamespaceURI(prefix);
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                for (Map next : XMLSecurityStreamWriter.this.nsStack) {
                    for (Map.Entry entry : next.entrySet()) {
                        if (!namespaceURI.equals(((XMLSecNamespace)entry.getValue()).getNamespaceURI())) continue;
                        return (String)entry.getKey();
                    }
                }
                if (XMLSecurityStreamWriter.this.namespaceContext != null) {
                    return XMLSecurityStreamWriter.this.namespaceContext.getPrefix(namespaceURI);
                }
                return null;
            }

            public Iterator<?> getPrefixes(String namespaceURI) {
                Object next;
                ArrayList<Object> prefixList = new ArrayList<Object>(1);
                if (XMLSecurityStreamWriter.this.namespaceContext != null) {
                    Iterator<String> iterator = XMLSecurityStreamWriter.this.namespaceContext.getPrefixes(namespaceURI);
                    while (iterator.hasNext()) {
                        next = iterator.next();
                        prefixList.add(next);
                    }
                }
                Iterator stackIterator = XMLSecurityStreamWriter.this.nsStack.descendingIterator();
                while (stackIterator.hasNext()) {
                    next = (Map)stackIterator.next();
                    for (Map.Entry entry : next.entrySet()) {
                        if (prefixList.contains(entry.getKey())) {
                            prefixList.remove(entry.getKey());
                        }
                        if (!namespaceURI.equals(((XMLSecNamespace)entry.getValue()).getNamespaceURI())) continue;
                        prefixList.add(entry.getKey());
                    }
                }
                return Collections.unmodifiableList(prefixList).iterator();
            }
        };
    }

    private void putNamespaceOntoStack(String prefix, XMLSecNamespace namespace) {
        Map<String, XMLSecNamespace> namespaceMap = this.nsStack.peek();
        if (Collections.emptyMap() == namespaceMap) {
            this.nsStack.pop();
            namespaceMap = new HashMap<String, XMLSecNamespace>();
            this.nsStack.push(namespaceMap);
        }
        namespaceMap.put(prefix, namespace);
    }

    private void chainProcessEvent(XMLSecEvent xmlSecEvent) throws XMLStreamException {
        try {
            this.outputProcessorChain.reset();
            this.outputProcessorChain.processEvent(xmlSecEvent);
        }
        catch (XMLSecurityException e) {
            throw new XMLStreamException(e);
        }
        catch (XMLStreamException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("Trying to declare prefix xmlns (illegal as per NS 1.1 #4)")) {
                throw new XMLStreamException("If you hit this exception this most probably meansyou are using the javax.xml.transform.stax.StAXResult. Don't use it. It is buggy as hell.", e);
            }
            throw e;
        }
    }

    private void outputOpenStartElement() throws XMLStreamException {
        if (this.openStartElement != null) {
            this.chainProcessEvent(XMLSecEventFactory.createXmlSecStartElement(this.openStartElement, this.currentAttributes, this.nsStack.peek().values()));
            this.currentAttributes.clear();
            this.openStartElement = null;
        }
        if (this.haveToWriteEndElement) {
            this.haveToWriteEndElement = false;
            this.writeEndElement();
        }
        this.nsStack.push(Collections.emptyMap());
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.outputOpenStartElement();
        QName qName = new QName(localName);
        this.startElementStack.push(qName);
        this.openStartElement = qName;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.outputOpenStartElement();
        String prefix = this.getNamespaceContext().getPrefix(namespaceURI);
        QName qName = prefix == null ? new QName(namespaceURI, localName) : new QName(namespaceURI, localName, prefix);
        this.startElementStack.push(qName);
        this.openStartElement = qName;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.outputOpenStartElement();
        QName qName = new QName(namespaceURI, localName, prefix);
        this.startElementStack.push(qName);
        this.openStartElement = qName;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.haveToWriteEndElement = true;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.haveToWriteEndElement = true;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.haveToWriteEndElement = true;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.outputOpenStartElement();
        QName element = this.startElementStack.pop();
        this.nsStack.pop();
        this.chainProcessEvent(XMLSecEventFactory.createXmlSecEndElement(element));
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (!this.endDocumentWritten) {
            this.outputOpenStartElement();
            Iterator<QName> startElements = this.startElementStack.iterator();
            while (startElements.hasNext()) {
                this.nsStack.pop();
                this.chainProcessEvent(XMLSecEventFactory.createXmlSecEndElement(startElements.next()));
            }
            this.chainProcessEvent(XMLSecEventFactory.createXMLSecEndDocument());
            this.endDocumentWritten = true;
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.writeEndDocument();
            this.outputProcessorChain.reset();
            this.outputProcessorChain.doFinal();
        }
        catch (XMLSecurityException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.currentAttributes.add(XMLSecEventFactory.createXMLSecAttribute(new QName(localName), value));
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.currentAttributes.add(XMLSecEventFactory.createXMLSecAttribute(new QName(namespaceURI, localName, prefix), value));
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.currentAttributes.add(XMLSecEventFactory.createXMLSecAttribute(new QName(namespaceURI, localName, this.getNamespaceContext().getPrefix(namespaceURI)), value));
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.putNamespaceOntoStack(prefix, XMLSecEventFactory.createXMLSecNamespace(prefix, namespaceURI));
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (this.openStartElement != null && this.openStartElement.getPrefix().equals("")) {
            this.openStartElement = new QName(namespaceURI, this.openStartElement.getLocalPart(), "");
        }
        this.putNamespaceOntoStack("", XMLSecEventFactory.createXMLSecNamespace(null, namespaceURI));
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXMLSecComment(data));
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXMLSecProcessingInstruction(target, ""));
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXMLSecProcessingInstruction(target, data));
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXMLSecCData(data));
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXMLSecDTD(dtd));
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXMLSecEntityReference(name, XMLSecEventFactory.createXmlSecEntityDeclaration(name)));
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.chainProcessEvent(XMLSecEventFactory.createXmlSecStartDocument(null, null, null, null));
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.chainProcessEvent(XMLSecEventFactory.createXmlSecStartDocument(null, null, null, version));
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.chainProcessEvent(XMLSecEventFactory.createXmlSecStartDocument(null, encoding, null, version));
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXmlSecCharacters(text));
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.outputOpenStartElement();
        this.chainProcessEvent(XMLSecEventFactory.createXmlSecCharacters(text, start, len));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.defaultNamespaceContext.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.putNamespaceOntoStack(prefix, XMLSecEventFactory.createXMLSecNamespace(prefix, uri));
        if (this.openStartElement != null && this.openStartElement.getNamespaceURI().equals(uri)) {
            this.openStartElement = new QName(this.openStartElement.getNamespaceURI(), this.openStartElement.getLocalPart(), prefix);
        }
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.putNamespaceOntoStack("", XMLSecEventFactory.createXMLSecNamespace("", uri));
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        this.namespaceContext = context;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.defaultNamespaceContext;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("Properties not supported");
    }
}

