/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl.processor.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.JCEAlgorithmMapper;
import org.apache.xml.security.stax.config.ResourceResolverMapper;
import org.apache.xml.security.stax.ext.AbstractOutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.ResourceResolver;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.Transformer;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityUtils;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.SignaturePartDef;
import org.apache.xml.security.stax.impl.transformer.TransformIdentity;
import org.apache.xml.security.stax.impl.util.DigestOutputStream;
import org.apache.xml.security.stax.impl.util.UnsynchronizedBufferedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureOutputProcessor
extends AbstractOutputProcessor {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractSignatureOutputProcessor.class);
    private final List<SignaturePartDef> signaturePartDefList = new ArrayList<SignaturePartDef>();
    private InternalSignatureOutputProcessor activeInternalSignatureOutputProcessor = null;

    public List<SignaturePartDef> getSignaturePartDefList() {
        return this.signaturePartDefList;
    }

    @Override
    public abstract void processEvent(XMLSecEvent var1, OutputProcessorChain var2) throws XMLStreamException, XMLSecurityException;

    @Override
    public void doFinal(OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        this.doFinalInternal(outputProcessorChain);
        super.doFinal(outputProcessorChain);
    }

    protected void doFinalInternal(OutputProcessorChain outputProcessorChain) throws XMLSecurityException, XMLStreamException {
        List<SignaturePartDef> signaturePartDefs = this.getSignaturePartDefList();
        Map dynamicSecureParts = outputProcessorChain.getSecurityContext().getAsMap("signatureParts");
        for (Map.Entry securePartEntry : dynamicSecureParts.entrySet()) {
            SecurePart securePart = (SecurePart)securePartEntry.getValue();
            String externalReference = securePart.getExternalReference();
            if (externalReference == null) continue;
            ResourceResolver resourceResolver = ResourceResolverMapper.getResourceResolver(externalReference, outputProcessorChain.getDocumentContext().getBaseURI());
            DigestOutputStream digestOutputStream = this.createMessageDigestOutputStream(securePart.getDigestMethod());
            InputStream inputStream = resourceResolver.getInputStreamFromExternalReference();
            SignaturePartDef signaturePartDef = new SignaturePartDef();
            signaturePartDef.setSecurePart(securePart);
            signaturePartDef.setSigRefId(externalReference);
            signaturePartDef.setExternalResource(true);
            signaturePartDef.setTransforms(securePart.getTransforms());
            String digestMethod = securePart.getDigestMethod();
            if (digestMethod == null) {
                digestMethod = this.getSecurityProperties().getSignatureDigestAlgorithm();
            }
            signaturePartDef.setDigestAlgo(digestMethod);
            signaturePartDefs.add(signaturePartDef);
            try {
                if (securePart.getTransforms() != null) {
                    signaturePartDef.setExcludeVisibleC14Nprefixes(true);
                    Transformer transformer = this.buildTransformerChain(digestOutputStream, signaturePartDef, null);
                    transformer.transform(inputStream);
                    transformer.doFinal();
                } else {
                    XMLSecurityUtils.copy(inputStream, digestOutputStream);
                }
                digestOutputStream.close();
            }
            catch (IOException e) {
                throw new XMLSecurityException(e);
            }
            String calculatedDigest = new String(Base64.encodeBase64((byte[])digestOutputStream.getDigestValue()));
            if (logger.isDebugEnabled()) {
                logger.debug("Calculated Digest: " + calculatedDigest);
            }
            signaturePartDef.setDigestValue(calculatedDigest);
        }
        this.verifySignatureParts(outputProcessorChain);
    }

    protected void verifySignatureParts(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
        List<SignaturePartDef> signaturePartDefs = this.getSignaturePartDefList();
        Map dynamicSecureParts = outputProcessorChain.getSecurityContext().getAsMap("signatureParts");
        block0: for (Map.Entry securePartEntry : dynamicSecureParts.entrySet()) {
            SecurePart securePart = (SecurePart)securePartEntry.getValue();
            if (!securePart.isRequired()) continue;
            for (int i = 0; i < signaturePartDefs.size(); ++i) {
                SignaturePartDef signaturePartDef = signaturePartDefs.get(i);
                if (signaturePartDef.getSecurePart() == securePart) continue block0;
            }
            throw new XMLSecurityException("stax.signature.securePartNotFound", securePart.getName());
        }
    }

    protected InternalSignatureOutputProcessor getActiveInternalSignatureOutputProcessor() {
        return this.activeInternalSignatureOutputProcessor;
    }

    protected void setActiveInternalSignatureOutputProcessor(InternalSignatureOutputProcessor activeInternalSignatureOutputProcessor) {
        this.activeInternalSignatureOutputProcessor = activeInternalSignatureOutputProcessor;
    }

    private DigestOutputStream createMessageDigestOutputStream(String digestAlgorithm) throws XMLSecurityException {
        MessageDigest messageDigest;
        String jceName = JCEAlgorithmMapper.translateURItoJCEID(digestAlgorithm);
        String jceProvider = JCEAlgorithmMapper.getJCEProviderFromURI(digestAlgorithm);
        if (jceName == null) {
            throw new XMLSecurityException("algorithms.NoSuchMap", digestAlgorithm);
        }
        try {
            messageDigest = jceProvider != null ? MessageDigest.getInstance(jceName, jceProvider) : MessageDigest.getInstance(jceName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XMLSecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new XMLSecurityException(e);
        }
        return new DigestOutputStream(messageDigest);
    }

    protected Transformer buildTransformerChain(OutputStream outputStream, SignaturePartDef signaturePartDef, XMLSecStartElement xmlSecStartElement) throws XMLSecurityException {
        String[] transforms = signaturePartDef.getTransforms();
        if (transforms == null || transforms.length == 0) {
            TransformIdentity transformer = new TransformIdentity();
            transformer.setOutputStream(outputStream);
            return transformer;
        }
        Transformer parentTransformer = null;
        for (int i = transforms.length - 1; i >= 0; --i) {
            String transform = transforms[i];
            ArrayList<String> inclusiveNamespacePrefixes = null;
            if (this.getSecurityProperties().isAddExcC14NInclusivePrefixes() && "http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform)) {
                Set<String> prefixSet = XMLSecurityUtils.getExcC14NInclusiveNamespacePrefixes(xmlSecStartElement, signaturePartDef.isExcludeVisibleC14Nprefixes());
                StringBuilder prefixes = new StringBuilder();
                for (String prefix : prefixSet) {
                    if (prefixes.length() != 0) {
                        prefixes.append(" ");
                    }
                    prefixes.append(prefix);
                }
                inclusiveNamespacePrefixes = new ArrayList<String>(prefixSet);
                signaturePartDef.setInclusiveNamespacesPrefixes(prefixes.toString());
            }
            parentTransformer = parentTransformer != null ? XMLSecurityUtils.getTransformer(parentTransformer, null, transform, XMLSecurityConstants.DIRECTION.OUT) : XMLSecurityUtils.getTransformer(inclusiveNamespacePrefixes, outputStream, transform, XMLSecurityConstants.DIRECTION.OUT);
        }
        return parentTransformer;
    }

    public class InternalSignatureOutputProcessor
    extends AbstractOutputProcessor {
        private SignaturePartDef signaturePartDef;
        private XMLSecStartElement xmlSecStartElement;
        private int elementCounter = 0;
        private OutputStream bufferedDigestOutputStream;
        private DigestOutputStream digestOutputStream;
        private Transformer transformer;

        public InternalSignatureOutputProcessor(SignaturePartDef signaturePartDef, XMLSecStartElement xmlSecStartElement) throws XMLSecurityException {
            this.addBeforeProcessor(InternalSignatureOutputProcessor.class.getName());
            this.signaturePartDef = signaturePartDef;
            this.xmlSecStartElement = xmlSecStartElement;
        }

        @Override
        public void init(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
            this.digestOutputStream = AbstractSignatureOutputProcessor.this.createMessageDigestOutputStream(this.signaturePartDef.getDigestAlgo());
            this.bufferedDigestOutputStream = new UnsynchronizedBufferedOutputStream(this.digestOutputStream);
            this.transformer = AbstractSignatureOutputProcessor.this.buildTransformerChain(this.bufferedDigestOutputStream, this.signaturePartDef, this.xmlSecStartElement);
            super.init(outputProcessorChain);
        }

        @Override
        public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            this.transformer.transform(xmlSecEvent);
            switch (xmlSecEvent.getEventType()) {
                case 1: {
                    ++this.elementCounter;
                    break;
                }
                case 2: {
                    --this.elementCounter;
                    if (this.elementCounter != 0 || !xmlSecEvent.asEndElement().getName().equals(this.xmlSecStartElement.getName())) break;
                    this.transformer.doFinal();
                    try {
                        this.bufferedDigestOutputStream.close();
                    }
                    catch (IOException e) {
                        throw new XMLSecurityException(e);
                    }
                    String calculatedDigest = new String(Base64.encodeBase64((byte[])this.digestOutputStream.getDigestValue()));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Calculated Digest: " + calculatedDigest);
                    }
                    this.signaturePartDef.setDigestValue(calculatedDigest);
                    outputProcessorChain.removeProcessor(this);
                    AbstractSignatureOutputProcessor.this.setActiveInternalSignatureOutputProcessor(null);
                }
            }
            outputProcessorChain.processEvent(xmlSecEvent);
        }
    }
}

