/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.db;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.sentry.core.model.db.DBModelAuthorizable;

public class AccessURI
implements DBModelAuthorizable {
    public static final AccessURI ALL = new AccessURI("*");
    private static final String AUTHORITY_PREFIX = "://";
    private final String uriName;

    public AccessURI(String uriName) {
        String string = uriName = uriName == null ? "" : uriName;
        if (!uriName.equals("*")) {
            Path uriPath = new Path(uriName);
            String schema = uriPath.toUri().getScheme();
            if (StringUtils.isBlank((String)schema) || !uriPath.isAbsolute()) {
                throw new IllegalArgumentException("URI '" + uriName + "' is invalid. Unsupported URI without schema or relative URI.");
            }
            if (!uriName.startsWith(schema + AUTHORITY_PREFIX)) {
                throw new IllegalArgumentException("URI '" + uriName + "' is invalid.");
            }
        }
        this.uriName = uriName;
    }

    public String getName() {
        return this.uriName;
    }

    @Override
    public DBModelAuthorizable.AuthorizableType getAuthzType() {
        return DBModelAuthorizable.AuthorizableType.URI;
    }

    public String toString() {
        return "URI [name=" + this.uriName + "]";
    }

    public String getTypeName() {
        return this.getAuthzType().name();
    }
}

